!Object constantsFor: 'Geos Libraries'!

geosLIB78 'SYSTEM\text'! !

!Object constantsFor: 'Geos vardata'!

attrVisTextTypeRuns 18432!
attrVisTextGraphicRuns 18436!
attrVisTextStyleArray 18440!
attrVisTextNameArray 18444!
attrVisTextSuspendData 18448!
attrVisTextNotifyContent 18452!
attrVisTextSelectedTab 18456!
attrVisTextDoNotInteractWithSearchControl 18460!
attrVisTextExtendedFilter 18464!
attrVisTextCharAttrInsertionToken 18468!
attrVisTextTypeInsertionToken 18472!
tempVisTextCachedRunInfo 18476!
tempVisTextForceSendIsLastRegion 18480!
tempVisTextCachedUndoInfo 18484!
attrVisTextCustomFilter 18488!
attrVisTextUpdateViaProcess 18492!
attrVisTextDoesNotAcceptInk 18496!
attrVisTextMinimumSingleLineHeight 18500!
tempVisTextSysTarget 18504!
attrVisTextSendContextNotificationsEvenIfNotFocused 18508!
attrVisTextDoNotNotifyContent 18512!
attrVisTextAddSpaceOnTopToFirstLineOfRegion 18516!
attrVisTextAddSpaceToAllLines 18520!
attrVisTextNotifyCursorPosition 18524!
tempVisTextNotifyCursorPositionTime 18528!
tempVisTextNotifyCursorPositionInfo 18532!
tempVisTextFreeingObject 18536!
tempVisTextUndoForSuspend 18540!
attrVisTextDisableOptimizedRedraw 18544!
attrVisTextDontShowPositionOnGainedTargetExcl 18548!
attrVisTextShowPositionOnGainedTargetExcl 18552!
attrVisTextDontBeepOnInsertionError 18556!
attrVisTextNoFep 18560!
attrVisTextNotifyEvenIfNotTargeted 18564!
attrVisTextXorSelection 18568!
tempVisTextCursorType 18572!
attrVisTextCursorNoFocus 18576!
attrVisTextNoCursor 18580!
attrFontControlShortListFontType 27648!
attrFontControlLongListFontType 27652!
attrSearchControlSetFindNextMoniker 27648!
attrSearchControlSetFindPrevMoniker 27652!
attrSearchControlSetReplaceCurrentMoniker 27656!
attrSearchControlSetReplaceAllMoniker 27660!
attrSearchControlSetReplaceAllInSelectionMoniker 27664!
attrSearchControlInteractOnlyWithTargetedTextObjects 27668!
attrSearchControlSelectionType 27672!
attrSearchControlSetFindFromTopMoniker 27676!
attrSearchControlSetIncludeNoteMoniker 27680!
attrSearchControlSetExcludeNoteMoniker 27684!
attrSearchControlSetNoteOnlyMoniker 27688!
tempCurrentContextIndex 27648!
!

!Object constantsFor: 'Geos messages'!

textGetRange 18432!
textSetCharAttrByDefault 18433!
textSetCharAttr 18434!
textSetCharAttrByToken 18435!
textGetCharAttr 18436!
textAddCharAttr 18437!
textRemoveCharAttr 18438!
textSetParaAttrByDefault 18439!
textSetParaAttr 18440!
textSetParaAttrByToken 18441!
textSetBorderBits 18442!
textSetBorderWidth 18443!
textSetBorderSpacing 18444!
textSetBorderShadow 18445!
textSetLineSpacing 18446!
textSetDefaultTabs 18447!
textSetLeftMargin 18448!
textSetRightMargin 18449!
textSetParaMargin 18450!
textSetLeftAndParaMargin 18451!
textSetSpaceOnTop 18452!
textSetSpaceOnBottom 18453!
textSetLeading 18454!
textSetParaBgColor 18455!
textSetParaBgGrayScreen 18456!
textSetParaBgPattern 18457!
textSetTab 18458!
textClearTab 18459!
textMoveTab 18460!
textClearAllTabs 18461!
textSetPrependChars 18462!
textSetHyphenationParams 18463!
textSetDropCapParams 18464!
textSetKeepParams 18465!
textSetParagraphNumber 18466!
textGetParaAttr 18467!
textAddParaAttr 18468!
textRemoveParaAttr 18469!
textSubstAttrToken 18470!
textRecalcForAttrChange 18471!
textSetHyperlink 18472!
textSetContext 18473!
textGetType 18475!
textAddType 18476!
textRemoveType 18477!
textAddName 18478!
textFindName 18479!
textFindNameByToken 18480!
textAddRefForName 18481!
textRemoveName 18482!
textReplaceWithGraphic 18483!
textGetGraphicAtPosition 18484!
textGraphicVariableSize 18485!
textGraphicVariableDraw 18486!
textGraphicVariableStartSelect 18487!
textGraphicVariableOpen 18488!
textGraphicVariableClose 18489!
textSaveToDbItem 18490!
textSaveToDbGroupItem 18490!
textSaveToDbItemWithStyles 18491!
textLoadFromDbItem 18492!
textLoadFromDbGroupItem 18492!
textLoadFromDbItemWithStyles 18493!
textSetVmFile 18494!
textCreateStorage 18495!
textChangeElementArray 18496!
textFreeStorage 18497!
textReplaceWithTextTransferFormat 18498!
textCreateTransferFormat 18499!
textReplaceAllPtr 18500!
textReplaceAllOptr 18501!
textReplaceAllBlock 18502!
textReplaceAllVmBlock 18503!
textReplaceAllDbItem 18504!
textReplaceAllHugeArray 18505!
textReplaceSelectionPtr 18506!
textReplaceSelectionOptr 18507!
textReplaceSelectionBlock 18508!
textReplaceSelectionVmBlock 18509!
textReplaceSelectionDbItem 18510!
textReplaceSelectionHugeArray 18511!
textAppendPtr 18512!
textAppendOptr 18513!
textAppendBlock 18514!
textAppendVmBlock 18515!
textAppendDbItem 18516!
textAppendHugeArray 18517!
textGetAllPtr 18518!
textGetAllOptr 18519!
textGetAllBlock 18520!
textGetAllVmBlock 18521!
textGetAllDbItem 18522!
textGetAllHugeArray 18523!
textGetSelectionPtr 18524!
textGetSelectionOptr 18525!
textGetSelectionBlock 18526!
textGetSelectionVmBlock 18527!
textGetSelectionDbItem 18528!
textGetSelectionHugeArray 18529!
textDeleteAll 18530!
textDeleteSelection 18531!
textGetSelectionRange 18532!
textSelectRangeSmall 18533!
textSelectAll 18534!
textSelectStart 18535!
textSelectEnd 18536!
textSelectRelative 18537!
textGetState 18538!
textGetFeatures 18539!
textSetFeatures 18540!
textSetMaxLength 18541!
textGetMaxLength 18542!
textGetUserModifiedState 18543!
textSetNotUserModified 18544!
textSetUserModified 18545!
textSetWashColor 18546!
textGetWashColor 18547!
textModifyEditableSelectable 18548!
textUpdateGeneric 18549!
textGenerateNotify 18550!
textCharAttrVirtualToPhysical 18551!
textParaAttrVirtualToPhysical 18552!
textEditDraw 18553!
textShowSelection 18554!
textHeightNotify 18555!
textEnterOverstrikeMode 18556!
textEnterInsertMode 18557!
textGetMinimumDimensions 18558!
textFilterViaReplaceParams 18559!
textFilterViaCharacter 18560!
textFilterViaBeforeAfter 18561!
textLoadStyleSheet 18562!
textLoadStyleSheetParams 18563!
textGetMinWidth 18564!
textGetAverageCharWidth 18565!
textCalcHeight 18566!
textGetLineHeight 18567!
textRecalcAndDraw 18568!
textGetOneLineWidth 18569!
textGetSimpleMinWidth 18570!
textScrollOneLine 18571!
textGetScrollAmount 18572!
textScrollPageUp 18573!
textScrollPageDown 18574!
textScreenUpdate 18575!
textFlashCursorOn 18576!
textFlashCursorOff 18577!
textSpellCheckFromOffset 18578!
textSearchFromOffset 18579!
textReplaceAllOccurrencesFromOffset 18580!
textReplaceAllOccurrencesInRange 18581!
textDoKeyFunction 18583!
textReplaceText 18584!
textGetTextRange 18585!
textSelectRange 18586!
textShowPosition 18587!
textSetFilter 18588!
textGetFilter 18589!
textSetOutput 18590!
textGetOutput 18591!
textSetLrMargin 18592!
textGetLrMargin 18593!
textSetTbMargin 18594!
textGetTbMargin 18595!
textReplaceWithHwr 18596!
textSetHwrContext 18597!
textSetHwrFilter 18598!
textSetSelectedTab 18599!
textGetTextSize 18600!
textInvalidateRange 18601!
textAttributeChange 18602!
textGetLineInfo 18603!
textDefineName 18604!
textDeleteName 18605!
textRenameName 18606!
textUpdateNameList 18607!
textGetNameListMoniker 18608!
textFollowHyperlink 18609!
textGetLineFromOffset 18610!
textGetLineOffsetAndFlags 18611!
textGetTextPositionFromCoord 18612!
textGetNameListNameType 18613!
textCrossSectionReplaceAborted 18614!
textSetSpellInProgress 18615!
textSetSearchInProgress 18616!
textLoadFromDbItemFormat 18617!
textGetRunBounds 18618!
textFreeAllStorage 18619!
textGenerateCursorPositionNotification 18620!
textGetSelectionStart 18621!
textGetGstate 18622!
textGetFepBounds 18623!
textDeleteAllHyperlinks 18624!
textUnsetAllContexts 18625!
textConvertOffsetToCoordinate 18626!
textSetHyperlinkTextStyle 18627!
textUpdateGraphicElement 18628!
textNameTokensToListIndices 18629!
textFindNameByIndex 18630!
textRegionFromPoint 18631!
textGetNameListMonikerFrame 18632!
textGetSingleCharAttr 18633!
textSetContextGivenNameText 18634!
textRedirectHyperlinks 18635!
rulerSetGcnContent 18944!
rulerSetControlledAttrs 18945!
largeTextCreateDataStructures 18944!
largeTextAppendRegion 18945!
largeTextRegionIsLast 18946!
largeTextCurrentRegionChanged 18947!
largeTextRegionChanged 18948!
largeTextSetDisplayMode 18949!
largeTextSetDraftRegionSize 18950!
largeTextGetDraftRegionSize 18951!
largeTextGetRegionCount 18952!
largeTextGetRegionPos 18953!
largeTextRegionFromPoint 18954!
setSimpleBorder 27648!
setBorderBits 27649!
setBorderWidth 27650!
setBorderSpacing 27651!
setBorderType 27652!
borderTypeStatus 27653!
setBorderAnchor 27654!
setShadowWidth 27655!
borderSidesStatus 27656!
setDefaultTabs 27648!
setDefaultTabsViaList 27649!
setDropCap 27648!
userChangedDropCap 27649!
setDropChars 27650!
setDropLines 27651!
setDropPosition 27652!
setFontWeight 27648!
setFontWidth 27649!
setTrackKerning 27650!
setFont 27648!
setFontFromList 27649!
userChangedFontFromList 27650!
setHyphenation 27648!
userChangedHyphenation 27649!
setMaxRange 27650!
setMinWord 27651!
setMinPrefix 27652!
setMinSuffix 27653!
setJustification 27648!
setLineSpacing 27648!
setLineSpacingWwFixed 27649!
setLeadingType 27650!
userChangedLeadingType 27651!
setManualLeading 27652!
setLeftMargin 27648!
setParaMargin 27649!
setRightMargin 27650!
setParaAttr 27648!
setKeep 27649!
userChangedKeep 27650!
setKeepFirst 27651!
setKeepLast 27652!
setSpaceOnTop 27648!
setSpaceOnBottom 27649!
setPointSize 27648!
setPointSizeFromList 27649!
smallerPointSize 27650!
largerPointSize 27651!
sendEventToSearchText 27648!
sendEventToReplaceText 27649!
replaceAllOccurrencesQueryResponse 27650!
replaceAllOccurrencesNoQuery 27651!
findNext 27652!
findPrev 27653!
addSpecialCharToFocusText 27654!
updateSpecialCharsByFocusInfo 27655!
searchAborted 27656!
searchStringNotFoundForSearch 27657!
searchStringNotFoundForReplaceAll 27658!
searchStringNotFoundForReplaceAllInSelection 27659!
findFromTop 27660!
getNoteSearchState 27661!
selectTab 27648!
queryTab 27649!
setTabLine 27650!
clearTab 27651!
clearAllTabs 27652!
setTabType 27653!
recalc 27648!
addContext 27648!
deleteContext 27649!
renameContext 27650!
setContext 27651!
dcGetMoniker 27652!
scGetMoniker 27653!
addFile 27654!
deleteFile 27655!
renameFile 27656!
dfGetMoniker 27657!
dfFileChanged 27658!
shFileChanged 27659!
setHyperlink 27660!
followHyperlink 27661!
shGetMoniker 27662!
dcContextChanged 27663!
deleteAllHyperlinks 27664!
unsetAllContexts 27665!
changeState 27648!
plainTextChange 27648!
styleChange 27649!
extendedStyleChange 27650!
!

!Geos class methodsFor: 'library calls'!

TextSearchInString: str1 with: startPtr with: endPtr with: str1Size with: str2 with: str2Size with: searchOptions with: matchLen
	"char * pascal TextSearchInString(const char *str1, const char *startPtr, const char *endPtr, word str1Size, const char *str2, word str2Size, word searchOptions, word *matchLen) in objects/vtextc.goh"
	^GEOS call: str1 with: startPtr with: endPtr with: str1Size with: str2 with: str2Size with: searchOptions with: matchLen with: #[78 0 11 3 3 3 1 3 1 1 3 3]!

TextSearchInHugeArray: str2 with: str2Size with: str1Size with: curOffset with: endOffset with: hugeArrayFile with: hugeArrayBlock with: searchOptions with: matchLen
	"dword pascal TextSearchInHugeArray(char *str2, word str2Size, dword str1Size, dword curOffset, dword endOffset, FileHandle hugeArrayFile, VMBlockHandle hugeArrayBlock, word searchOptions, dword *matchLen) in objects/vtextc.goh"
	^GEOS call: str2 with: str2Size with: str1Size with: curOffset with: endOffset with: hugeArrayFile with: hugeArrayBlock with: searchOptions with: matchLen with: #[78 0 12 3 1 2 2 2 1 1 1 3 2]!

TextMapDefaultCharAttr: defaulAttr with: attr
	"void pascal TextMapDefaultCharAttr(VisTextDefaultCharAttr defaulAttr, VisTextCharAttr *attr) in objects/vtextc.goh"
	^GEOS call: defaulAttr with: attr with: #[78 0 45 1 3 0]!

TextFindDefaultCharAttr: defaultAttr with: attr
	"Boolean pascal TextFindDefaultCharAttr(VisTextDefaultCharAttr *defaultAttr, VisTextCharAttr *attr) in objects/vtextc.goh"
	^GEOS call: defaultAttr with: attr with: #[78 0 46 3 3 4]!

TextMapDefaultParaAttr: defaulAttr with: attr
	"void pascal TextMapDefaultParaAttr(VisTextDefaultParaAttr defaulAttr, VisTextParaAttr *attr) in objects/vtextc.goh"
	^GEOS call: defaulAttr with: attr with: #[78 0 47 1 3 0]!

TextFindDefaultParaAttr: defaultAttr with: attr
	"Boolean pascal TextFindDefaultParaAttr(VisTextDefaultParaAttr *defaultAttr, VisTextParaAttr *attr) in objects/vtextc.goh"
	^GEOS call: defaultAttr with: attr with: #[78 0 48 3 3 4]!

TextGetSystemCharAttrRun: chunkOrConstant with: object with: flags
	"Boolean pascal TextGetSystemCharAttrRun(word *chunkOrConstant, optr object, ObjChunkFlags flags) in objects/vtextc.goh"
	^GEOS call: chunkOrConstant with: object with: flags with: #[78 0 49 3 2 1 4]!

TextSetSpellLibrary: libHandle
	"void pascal TextSetSpellLibrary(MemHandle libHandle) in objects/vtextc.goh"
	^GEOS call: libHandle with: #[78 0 40 1 0]!

TextSetHyphenationCall: hyphenationWordEntryPoint
	"void pascal TextSetHyphenationCall(void *hyphenationWordEntryPoint) in objects/vtextc.goh"
	^GEOS call: hyphenationWordEntryPoint with: #[78 0 41 3 0]!

VisTextFormatNumber: buf with: num with: numtype
	"void pascal VisTextFormatNumber(char *buf, dword num, VisTextNumberType numtype) in objects/vtextc.goh"
	^GEOS call: buf with: num with: numtype with: #[78 0 38 3 2 1 0]!

VTFClearSmartQuotes
	"void pascal VTFClearSmartQuotes() in objects/vtextc.goh"
	^GEOS call: #[78 0 44 0]!

TextAllocClipboardObject: file with: storageFlags with: regionFlag
	"optr pascal TextAllocClipboardObject(VMFileHandle file, VisTextStorageFlags storageFlags, byte regionFlag) in objects/vtextc.goh"
	^GEOS call: file with: storageFlags with: regionFlag with: #[78 0 32 1 1 1 2]!

TextFinishWithClipboardObject: obj with: opt with: owner with: name
	"VMBlockHandle pascal TextFinishWithClipboardObject(optr obj, TextClipboardOption opt, optr owner, const char *name) in objects/vtextc.goh"
	^GEOS call: obj with: opt with: owner with: name with: #[78 0 33 2 1 2 3 1]!

MsgVisTextLoadStyleSheetParams: params with: object with: preserveArrays
	"void pascal MsgVisTextLoadStyleSheetParams(StyleSheetParams *params, optr object, word preserveArrays) in objects/vtextc.goh"
	^GEOS call: params with: object with: preserveArrays with: #[78 0 51 3 2 1 0]!

MsgVisLargeTextRegionFromPoint: retValue with: object with: point
	"void pascal MsgVisLargeTextRegionFromPoint( VisLargeTextRegionFromPointParams *retValue, optr object, PointDWFixed point) in objects/vltextc.goh"
	^GEOS call: retValue with: object with: point with: #[78 0 50 3 2 64 12 0]!

!

Vis subclass: #VisText
	instanceVariableNames: ''
	classVariableNames: ''!

VisRuler subclass: #TextRuler
	instanceVariableNames: ''
	classVariableNames: ''!

VisText subclass: #VisLargeText
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #BorderControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #DefaultTabsControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #DropCapControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #FontAttrControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #FontControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #HyphenationControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #JustificationControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #LineSpacingControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #MarginControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #ParaAttrControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #ParaSpacingControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #PointSizeControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #SearchReplaceControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #TabControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #TextCountControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #TextHelpControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #TextRulerControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #TextStyleControl
	instanceVariableNames: ''
	classVariableNames: ''!

ColorSelector subclass: #BorderColorControl
	instanceVariableNames: ''
	classVariableNames: ''!

ColorSelector subclass: #CharBGColorControl
	instanceVariableNames: ''
	classVariableNames: ''!

ColorSelector subclass: #CharFGColorControl
	instanceVariableNames: ''
	classVariableNames: ''!

ColorSelector subclass: #ParaBGColorControl
	instanceVariableNames: ''
	classVariableNames: ''!

StyleSheetControl subclass: #TextStyleSheetControl
	instanceVariableNames: ''
	classVariableNames: ''!

!VisText comment!
Library text, file objects/vtextc.goh! !

!VisText class methodsFor: 'library linkage'!

library
	^78!

entry
	^0!
!

!VisText methodsFor: 'Geos instance variables'!

vtiText
	"@instance ChunkHandle VTI_text"
	^self wordAt: 17!

vtiText: value
	"@instance ChunkHandle VTI_text"
	^self wordAt: 17 put: value!

vtiCharAttrRuns
	"@instance word VTI_charAttrRuns"
	^self wordAt: 19!

vtiCharAttrRuns: value
	"@instance word VTI_charAttrRuns"
	^self wordAt: 19 put: value!

vtiParaAttrRuns
	"@instance word VTI_paraAttrRuns"
	^self wordAt: 21!

vtiParaAttrRuns: value
	"@instance word VTI_paraAttrRuns"
	^self wordAt: 21 put: value!

vtiVmFile
	"@instance VMFileHandle VTI_vmFile"
	^self wordAt: 23!

vtiVmFile: value
	"@instance VMFileHandle VTI_vmFile"
	^self wordAt: 23 put: value!

vtiLines
	"@instance word VTI_lines"
	^self wordAt: 25!

vtiLines: value
	"@instance word VTI_lines"
	^self wordAt: 25 put: value!

vtiStorageFlags
	"@instance VisTextStorageFlags VTI_storageFlags"
	^self byteAt: 27!

vtiStorageFlags: value
	"@instance VisTextStorageFlags VTI_storageFlags"
	^self byteAt: 27 put: value!

vtiFeatures
	"@instance VisTextFeatures VTI_features"
	^self wordAt: 28!

vtiFeatures: value
	"@instance VisTextFeatures VTI_features"
	^self wordAt: 28 put: value!

vtiState
	"@instance VisTextStates VTI_state"
	^self byteAt: 30!

vtiState: value
	"@instance VisTextStates VTI_state"
	^self byteAt: 30 put: value!

vtiIntFlags
	"@instance VisTextIntFlags VTI_intFlags"
	^self byteAt: 31!

vtiIntFlags: value
	"@instance VisTextIntFlags VTI_intFlags"
	^self byteAt: 31 put: value!

vtiIntSelFlags
	"@instance VisTextIntSelFlags VTI_intSelFlags"
	^self byteAt: 32!

vtiIntSelFlags: value
	"@instance VisTextIntSelFlags VTI_intSelFlags"
	^self byteAt: 32 put: value!

vtiGsRefCount
	"@instance GSRefCountAndFlags VTI_gsRefCount"
	^self byteAt: 33!

vtiGsRefCount: value
	"@instance GSRefCountAndFlags VTI_gsRefCount"
	^self byteAt: 33 put: value!

vtiGstate
	"@instance GStateHandle VTI_gstate"
	^self wordAt: 34!

vtiGstate: value
	"@instance GStateHandle VTI_gstate"
	^self wordAt: 34 put: value!

vtiGstateRegion
	"@instance word VTI_gstateRegion"
	^self wordAt: 36!

vtiGstateRegion: value
	"@instance word VTI_gstateRegion"
	^self wordAt: 36 put: value!

vtiSelectStart
	"@instance dword VTI_selectStart"
	^self dwordAt: 38!

vtiSelectStart: value
	"@instance dword VTI_selectStart"
	^self dwordAt: 38 put: value!

vtiSelectEnd
	"@instance dword VTI_selectEnd"
	^self dwordAt: 42!

vtiSelectEnd: value
	"@instance dword VTI_selectEnd"
	^self dwordAt: 42 put: value!

vtiStartEventPos
	"@instance PointDWord VTI_startEventPos"
	^GCSPointDWord forPointer: (self ptrAt: 46).!

vtiStartEventPos: aBlock
	"@instance PointDWord VTI_startEventPos"
	aBlock value: (GCSPointDWord forPointer: (self ptrAt: 46)).!

vtiSelectMinStart
	"@instance dword VTI_selectMinStart"
	^self dwordAt: 54!

vtiSelectMinStart: value
	"@instance dword VTI_selectMinStart"
	^self dwordAt: 54 put: value!

vtiSelectMinEnd
	"@instance dword VTI_selectMinEnd"
	^self dwordAt: 58!

vtiSelectMinEnd: value
	"@instance dword VTI_selectMinEnd"
	^self dwordAt: 58 put: value!

vtiLastOffset
	"@instance dword VTI_lastOffset"
	^self dwordAt: 62!

vtiLastOffset: value
	"@instance dword VTI_lastOffset"
	^self dwordAt: 62 put: value!

vtiGoalPosition
	"@instance word VTI_goalPosition"
	^self wordAt: 66!

vtiGoalPosition: value
	"@instance word VTI_goalPosition"
	^self wordAt: 66 put: value!

vtiCursorPos
	"@instance Point VTI_cursorPos"
	^GCSPoint forPointer: (self ptrAt: 68).!

vtiCursorPos: aBlock
	"@instance Point VTI_cursorPos"
	aBlock value: (GCSPoint forPointer: (self ptrAt: 68)).!

vtiCursorRegion
	"@instance word VTI_cursorRegion"
	^self wordAt: 72!

vtiCursorRegion: value
	"@instance word VTI_cursorRegion"
	^self wordAt: 72 put: value!

vtiLeftOffset
	"@instance word VTI_leftOffset"
	^self wordAt: 74!

vtiLeftOffset: value
	"@instance word VTI_leftOffset"
	^self wordAt: 74 put: value!

vtiLrMargin
	"@instance byte VTI_lrMargin"
	^self byteAt: 76!

vtiLrMargin: value
	"@instance byte VTI_lrMargin"
	^self byteAt: 76 put: value!

vtiTbMargin
	"@instance byte VTI_tbMargin"
	^self byteAt: 77!

vtiTbMargin: value
	"@instance byte VTI_tbMargin"
	^self byteAt: 77 put: value!

vtiWashColor
	"@instance ColorQuad VTI_washColor"
	^GCSColorQuad forPointer: (self ptrAt: 78).!

vtiWashColor: aBlock
	"@instance ColorQuad VTI_washColor"
	aBlock value: (GCSColorQuad forPointer: (self ptrAt: 78)).!

vtiMaxLength
	"@instance word VTI_maxLength"
	^self wordAt: 82!

vtiMaxLength: value
	"@instance word VTI_maxLength"
	^self wordAt: 82 put: value!

vtiFilters
	"@instance VisTextFilters VTI_filters"
	^self byteAt: 84!

vtiFilters: value
	"@instance VisTextFilters VTI_filters"
	^self byteAt: 84 put: value!

vtiOutput
	"@instance optr VTI_output"
	^self dwordAt: 85!

vtiOutput: value
	"@instance optr VTI_output"
	^self dwordAt: 85 put: value!

vtiHeight
	"@instance WBFixed VTI_height"
	^GCSWBFixed forPointer: (self ptrAt: 89).!

vtiHeight: aBlock
	"@instance WBFixed VTI_height"
	aBlock value: (GCSWBFixed forPointer: (self ptrAt: 89)).!

vtiLastWidth
	"@instance word VTI_lastWidth"
	^self wordAt: 92!

vtiLastWidth: value
	"@instance word VTI_lastWidth"
	^self wordAt: 92 put: value!

vtiTimerHandle
	"@instance TimerHandle VTI_timerHandle"
	^self wordAt: 94!

vtiTimerHandle: value
	"@instance TimerHandle VTI_timerHandle"
	^self wordAt: 94 put: value!

vtiTimerID
	"@instance word VTI_timerID"
	^self wordAt: 96!

vtiTimerID: value
	"@instance word VTI_timerID"
	^self wordAt: 96 put: value!

!

!VisText methodsFor: 'Geos vardata'!

attrVisTextTypeRuns: value
	"@vardata word ATTR_VIS_TEXT_TYPE_RUNS"
	^self addVardata: ##attrVisTextTypeRuns word: value!

attrVisTextGraphicRuns: value
	"@vardata word ATTR_VIS_TEXT_GRAPHIC_RUNS"
	^self addVardata: ##attrVisTextGraphicRuns word: value!

attrVisTextStyleArray: value
	"@vardata word ATTR_VIS_TEXT_STYLE_ARRAY"
	^self addVardata: ##attrVisTextStyleArray word: value!

attrVisTextNameArray: value
	"@vardata word ATTR_VIS_TEXT_NAME_ARRAY"
	^self addVardata: ##attrVisTextNameArray word: value!

attrVisTextSuspendData
	"@vardata VisTextSuspendData ATTR_VIS_TEXT_SUSPEND_DATA"
	^self addVardata: ##attrVisTextSuspendData size: 25!

attrVisTextSuspendData: aBlock
	"@vardata VisTextSuspendData ATTR_VIS_TEXT_SUSPEND_DATA"
	aBlock value: (GCSVisTextSuspendData forPointer: (self addVardata: ##attrVisTextSuspendData size: 25)).!

attrVisTextNotifyContent
	"@vardata void ATTR_VIS_TEXT_NOTIFY_CONTENT"
	^self addVardata: ##attrVisTextNotifyContent!

attrVisTextSelectedTab: value
	"@vardata word ATTR_VIS_TEXT_SELECTED_TAB"
	^self addVardata: ##attrVisTextSelectedTab word: value!

attrVisTextDoNotInteractWithSearchControl
	"@vardata void ATTR_VIS_TEXT_DO_NOT_INTERACT_WITH_SEARCH_CONTROL"
	^self addVardata: ##attrVisTextDoNotInteractWithSearchControl!

attrVisTextExtendedFilter: value
	"@vardata VisTextExtendedFilterType ATTR_VIS_TEXT_EXTENDED_FILTER"
	^self addVardata: ##attrVisTextExtendedFilter byte: value!

attrVisTextCharAttrInsertionToken: value
	"@vardata word ATTR_VIS_TEXT_CHAR_ATTR_INSERTION_TOKEN"
	^self addVardata: ##attrVisTextCharAttrInsertionToken word: value!

attrVisTextTypeInsertionToken: value
	"@vardata word ATTR_VIS_TEXT_TYPE_INSERTION_TOKEN"
	^self addVardata: ##attrVisTextTypeInsertionToken word: value!

tempVisTextCachedRunInfo
	"@vardata VisTextCachedRunInfo TEMP_VIS_TEXT_CACHED_RUN_INFO"
	^self addVardata: ##tempVisTextCachedRunInfo size: 16!

tempVisTextCachedRunInfo: aBlock
	"@vardata VisTextCachedRunInfo TEMP_VIS_TEXT_CACHED_RUN_INFO"
	aBlock value: (GCSVisTextCachedRunInfo forPointer: (self addVardata: ##tempVisTextCachedRunInfo size: 16)).!

tempVisTextForceSendIsLastRegion
	"@vardata void TEMP_VIS_TEXT_FORCE_SEND_IS_LAST_REGION"
	^self addVardata: ##tempVisTextForceSendIsLastRegion!

tempVisTextCachedUndoInfo
	"@vardata VisTextCachedUndoInfo TEMP_VIS_TEXT_CACHED_UNDO_INFO"
	^self addVardata: ##tempVisTextCachedUndoInfo size: 6!

tempVisTextCachedUndoInfo: aBlock
	"@vardata VisTextCachedUndoInfo TEMP_VIS_TEXT_CACHED_UNDO_INFO"
	aBlock value: (GCSVisTextCachedUndoInfo forPointer: (self addVardata: ##tempVisTextCachedUndoInfo size: 6)).!

attrVisTextCustomFilter: value
	"@vardata ChunkHandle ATTR_VIS_TEXT_CUSTOM_FILTER"
	^self addVardata: ##attrVisTextCustomFilter word: value!

attrVisTextUpdateViaProcess
	"@vardata void ATTR_VIS_TEXT_UPDATE_VIA_PROCESS"
	^self addVardata: ##attrVisTextUpdateViaProcess!

attrVisTextDoesNotAcceptInk
	"@vardata void ATTR_VIS_TEXT_DOES_NOT_ACCEPT_INK"
	^self addVardata: ##attrVisTextDoesNotAcceptInk!

attrVisTextMinimumSingleLineHeight
	"@vardata WBFixed ATTR_VIS_TEXT_MINIMUM_SINGLE_LINE_HEIGHT"
	^self addVardata: ##attrVisTextMinimumSingleLineHeight size: 3!

attrVisTextMinimumSingleLineHeight: aBlock
	"@vardata WBFixed ATTR_VIS_TEXT_MINIMUM_SINGLE_LINE_HEIGHT"
	aBlock value: (GCSWBFixed forPointer: (self addVardata: ##attrVisTextMinimumSingleLineHeight size: 3)).!

tempVisTextSysTarget
	"@vardata void TEMP_VIS_TEXT_SYS_TARGET"
	^self addVardata: ##tempVisTextSysTarget!

attrVisTextSendContextNotificationsEvenIfNotFocused
	"@vardata void ATTR_VIS_TEXT_SEND_CONTEXT_NOTIFICATIONS_EVEN_IF_NOT_FOCUSED"
	^self addVardata: ##attrVisTextSendContextNotificationsEvenIfNotFocused!

attrVisTextDoNotNotifyContent
	"@vardata void ATTR_VIS_TEXT_DO_NOT_NOTIFY_CONTENT"
	^self addVardata: ##attrVisTextDoNotNotifyContent!

attrVisTextAddSpaceOnTopToFirstLineOfRegion: value
	"@vardata word ATTR_VIS_TEXT_ADD_SPACE_ON_TOP_TO_FIRST_LINE_OF_REGION"
	^self addVardata: ##attrVisTextAddSpaceOnTopToFirstLineOfRegion word: value!

attrVisTextAddSpaceToAllLines: value
	"@vardata word ATTR_VIS_TEXT_ADD_SPACE_TO_ALL_LINES"
	^self addVardata: ##attrVisTextAddSpaceToAllLines word: value!

attrVisTextNotifyCursorPosition: value
	"@vardata word ATTR_VIS_TEXT_NOTIFY_CURSOR_POSITION"
	^self addVardata: ##attrVisTextNotifyCursorPosition word: value!

tempVisTextNotifyCursorPositionTime: value
	"@vardata dword TEMP_VIS_TEXT_NOTIFY_CURSOR_POSITION_TIME"
	^self addVardata: ##tempVisTextNotifyCursorPositionTime dword: value!

tempVisTextNotifyCursorPositionInfo
	"@vardata TVTNCPIData TEMP_VIS_TEXT_NOTIFY_CURSOR_POSITION_INFO"
	^self addVardata: ##tempVisTextNotifyCursorPositionInfo size: 4!

tempVisTextNotifyCursorPositionInfo: aBlock
	"@vardata TVTNCPIData TEMP_VIS_TEXT_NOTIFY_CURSOR_POSITION_INFO"
	aBlock value: (GCSTVTNCPIData forPointer: (self addVardata: ##tempVisTextNotifyCursorPositionInfo size: 4)).!

tempVisTextFreeingObject
	"@vardata void TEMP_VIS_TEXT_FREEING_OBJECT"
	^self addVardata: ##tempVisTextFreeingObject!

tempVisTextUndoForSuspend
	"@vardata void TEMP_VIS_TEXT_UNDO_FOR_SUSPEND"
	^self addVardata: ##tempVisTextUndoForSuspend!

attrVisTextDisableOptimizedRedraw
	"@vardata void ATTR_VIS_TEXT_DISABLE_OPTIMIZED_REDRAW"
	^self addVardata: ##attrVisTextDisableOptimizedRedraw!

attrVisTextDontShowPositionOnGainedTargetExcl
	"@vardata void ATTR_VIS_TEXT_DONT_SHOW_POSITION_ON_GAINED_TARGET_EXCL"
	^self addVardata: ##attrVisTextDontShowPositionOnGainedTargetExcl!

attrVisTextShowPositionOnGainedTargetExcl
	"@vardata void ATTR_VIS_TEXT_SHOW_POSITION_ON_GAINED_TARGET_EXCL"
	^self addVardata: ##attrVisTextShowPositionOnGainedTargetExcl!

attrVisTextDontBeepOnInsertionError
	"@vardata void ATTR_VIS_TEXT_DONT_BEEP_ON_INSERTION_ERROR"
	^self addVardata: ##attrVisTextDontBeepOnInsertionError!

attrVisTextNoFep
	"@vardata void ATTR_VIS_TEXT_NO_FEP"
	^self addVardata: ##attrVisTextNoFep!

attrVisTextNotifyEvenIfNotTargeted
	"@vardata void ATTR_VIS_TEXT_NOTIFY_EVEN_IF_NOT_TARGETED"
	^self addVardata: ##attrVisTextNotifyEvenIfNotTargeted!

attrVisTextXorSelection
	"@vardata void ATTR_VIS_TEXT_XOR_SELECTION"
	^self addVardata: ##attrVisTextXorSelection!

tempVisTextCursorType: value
	"@vardata VisTextCursorType TEMP_VIS_TEXT_CURSOR_TYPE"
	^self addVardata: ##tempVisTextCursorType word: value!

attrVisTextCursorNoFocus
	"@vardata void ATTR_VIS_TEXT_CURSOR_NO_FOCUS"
	^self addVardata: ##attrVisTextCursorNoFocus!

attrVisTextNoCursor
	"@vardata void ATTR_VIS_TEXT_NO_CURSOR"
	^self addVardata: ##attrVisTextNoCursor!

!

!VisText methodsFor: 'Geos messages'!

textGetRange: range with: context
	"@message void MSG_VIS_TEXT_GET_RANGE(VisTextRange *range = dx:bp, VisTextRangeContext context = cx)"
	^self geosMessage: #[72 0 3 126 3 1 0] with: range with: context!

textSetCharAttrByDefault: defCharAttrs with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_CHAR_ATTR_BY_DEFAULT(@stack VisTextDefaultCharAttr defCharAttrs, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 1 0 10 1 2 2 0] with: defCharAttrs with: rangeEnd with: rangeStart!

textSetCharAttr: attrs with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_CHAR_ATTR(@stack VisTextCharAttr *attrs, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 2 0 12 3 2 2 0] with: attrs with: rangeEnd with: rangeStart!

textSetCharAttrByToken: token with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_CHAR_ATTR_BY_TOKEN(@stack word token, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 3 0 10 1 2 2 0] with: token with: rangeEnd with: rangeStart!

textGetCharAttr: flags with: diffs with: attrs with: rangeEnd with: rangeStart
	"@message word MSG_VIS_TEXT_GET_CHAR_ATTR(@stack VisTextGetAttrFlags flags, VisTextCharAttrDiffs *diffs, VisTextCharAttr *attrs, dword rangeEnd, dword rangeStart)= ax"
	^self geosMessage: #[72 4 96 18 1 3 3 2 2 1] with: flags with: diffs with: attrs with: rangeEnd with: rangeStart!

textAddCharAttr: attrs
	"@message void MSG_VIS_TEXT_ADD_CHAR_ATTR(@stack VisTextCharAttr *attrs)= ax"
	^self geosMessage: #[72 5 96 4 3 0] with: attrs!

textRemoveCharAttr: attrToken
	"@message void MSG_VIS_TEXT_REMOVE_CHAR_ATTR(word attrToken = cx)"
	^self geosMessage: #[72 6 2 5 1 0] with: attrToken!

textSetParaAttrByDefault: defParaAttrs with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_PARA_ATTR_BY_DEFAULT(@stack VisTextDefaultParaAttr defParaAttrs, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 7 0 10 1 2 2 0] with: defParaAttrs with: rangeEnd with: rangeStart!

textSetParaAttr: newParaAttrs with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_PARA_ATTR(@stack VisTextParaAttr *newParaAttrs, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 8 0 12 3 2 2 0] with: newParaAttrs with: rangeEnd with: rangeStart!

textSetParaAttrByToken: paraAttrToken with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_PARA_ATTR_BY_TOKEN(@stack word paraAttrToken, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 9 0 10 1 2 2 0] with: paraAttrToken with: rangeEnd with: rangeStart!

textSetBorderBits: bitsToClear with: bitsToSet with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_BORDER_BITS(@stack VisTextParaBorderFlags bitsToClear, VisTextParaBorderFlags bitsToSet, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 10 0 12 1 1 2 2 0] with: bitsToClear with: bitsToSet with: rangeEnd with: rangeStart!

textSetBorderWidth: width with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_BORDER_WIDTH(@stack byte width, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 11 0 10 1 2 2 0] with: width with: rangeEnd with: rangeStart!

textSetBorderSpacing: width with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_BORDER_SPACING(@stack byte width, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 12 0 10 1 2 2 0] with: width with: rangeEnd with: rangeStart!

textSetBorderShadow: width with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_BORDER_SHADOW(@stack byte width, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 13 0 10 1 2 2 0] with: width with: rangeEnd with: rangeStart!

textSetLineSpacing: lineSpacing with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_LINE_SPACING(@stack BBFixed lineSpacing, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 14 0 10 1 2 2 0] with: lineSpacing with: rangeEnd with: rangeStart!

textSetDefaultTabs: defaultTabs with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_DEFAULT_TABS(@stack word defaultTabs, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 15 0 10 1 2 2 0] with: defaultTabs with: rangeEnd with: rangeStart!

textSetLeftMargin: position with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_LEFT_MARGIN(@stack word position, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 16 0 10 1 2 2 0] with: position with: rangeEnd with: rangeStart!

textSetRightMargin: position with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_RIGHT_MARGIN(@stack word position, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 17 0 10 1 2 2 0] with: position with: rangeEnd with: rangeStart!

textSetParaMargin: position with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_PARA_MARGIN(@stack word position, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 18 0 10 1 2 2 0] with: position with: rangeEnd with: rangeStart!

textSetLeftAndParaMargin: position with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_LEFT_AND_PARA_MARGIN(@stack word position, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 19 0 10 1 2 2 0] with: position with: rangeEnd with: rangeStart!

textSetSpaceOnTop: spacing with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_SPACE_ON_TOP(@stack BBFixed spacing, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 20 0 10 1 2 2 0] with: spacing with: rangeEnd with: rangeStart!

textSetSpaceOnBottom: spacing with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_SPACE_ON_BOTTOM(@stack BBFixed spacing, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 21 0 10 1 2 2 0] with: spacing with: rangeEnd with: rangeStart!

textSetLeading: leading with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_LEADING(@stack word leading, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 22 0 10 1 2 2 0] with: leading with: rangeEnd with: rangeStart!

textSetParaBgColor: color with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_PARA_BG_COLOR(@stack ColorQuad color, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 23 0 12 2 2 2 0] with: color with: rangeEnd with: rangeStart!

textSetParaBgGrayScreen: grayScreen with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_PARA_BG_GRAY_SCREEN(@stack SystemDrawMask grayScreen, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 24 0 10 1 2 2 0] with: grayScreen with: rangeEnd with: rangeStart!

textSetParaBgPattern: hatch with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_PARA_BG_PATTERN(@stack GraphicPattern hatch, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 25 0 10 1 2 2 0] with: hatch with: rangeEnd with: rangeStart!

textSetTab: tab with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_TAB(@stack Tab tab, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 26 0 16 64 8 2 2 0] with: tab with: rangeEnd with: rangeStart!

textClearTab: position with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_CLEAR_TAB(@stack word position, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 27 0 10 1 2 2 0] with: position with: rangeEnd with: rangeStart!

textMoveTab: destPosition with: sourcePosition with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_MOVE_TAB(@stack word destPosition, word sourcePosition, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 28 0 12 1 1 2 2 0] with: destPosition with: sourcePosition with: rangeEnd with: rangeStart!

textClearAllTabs: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_CLEAR_ALL_TABS(@stack dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 29 0 8 2 2 0] with: rangeEnd with: rangeStart!

textSetPrependChars: prependChars with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_PREPEND_CHARS(@stack char prependChars[4], dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 30 0 12 3 2 2 0] with: prependChars with: rangeEnd with: rangeStart!

textSetHyphenationParams: bitsToSet with: bitsToClear with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_HYPHENATION_PARAMS(@stack VisTextHyphenationInfo bitsToSet, VisTextHyphenationInfo bitsToClear, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 31 0 12 1 1 2 2 0] with: bitsToSet with: bitsToClear with: rangeEnd with: rangeStart!

textSetDropCapParams: bitsToSet with: bitsToClear with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_DROP_CAP_PARAMS(@stack VisTextDropCapInfo bitsToSet, VisTextDropCapInfo bitsToClear, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 32 0 12 1 1 2 2 0] with: bitsToSet with: bitsToClear with: rangeEnd with: rangeStart!

textSetKeepParams: bitsToSet with: bitsToClear with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_KEEP_PARAMS(@stack VisTextKeepInfo bitsToSet, VisTextKeepInfo bitsToClear, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 33 0 12 1 1 2 2 0] with: bitsToSet with: bitsToClear with: rangeEnd with: rangeStart!

textSetParagraphNumber: startingParaNumber with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_PARAGRAPH_NUMBER(@stack word startingParaNumber, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 34 0 10 1 2 2 0] with: startingParaNumber with: rangeEnd with: rangeStart!

textGetParaAttr: flags with: diffs with: attrs with: rangeEnd with: rangeStart
	"@message word MSG_VIS_TEXT_GET_PARA_ATTR(@stack VisTextGetAttrFlags flags, VisTextParaAttrDiffs *diffs, VisTextMaxParaAttr *attrs, dword rangeEnd, dword rangeStart)= ax"
	^self geosMessage: #[72 35 96 18 1 3 3 2 2 1] with: flags with: diffs with: attrs with: rangeEnd with: rangeStart!

textAddParaAttr: attrs
	"@message word MSG_VIS_TEXT_ADD_PARA_ATTR(@stack VisTextParaAttr attrs)= ax"
	^self geosMessage: #[72 36 96 72 64 72 1] with: attrs!

textRemoveParaAttr: token
	"@message void MSG_VIS_TEXT_REMOVE_PARA_ATTR(word token = cx)"
	^self geosMessage: #[72 37 2 5 1 0] with: token!

textSubstAttrToken: recalcFlag with: relayed with: updateRefFlag with: runOffset with: newToken with: oldToken
	"@message void MSG_VIS_TEXT_SUBST_ATTR_TOKEN(@stack Boolean *recalcFlag, Boolean relayed, Boolean updateRefFlag, word runOffset, word newToken, word oldToken)"
	^self geosMessage: #[72 38 0 14 3 4 4 1 1 1 0] with: recalcFlag with: relayed with: updateRefFlag with: runOffset with: newToken with: oldToken!

textRecalcForAttrChange: relayed
	"@message void MSG_VIS_TEXT_RECALC_FOR_ATTR_CHANGE(Boolean relayed = cx)"
	^self geosMessage: #[72 39 2 5 4 0] with: relayed!

textSetHyperlink: flags with: file with: context with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_HYPERLINK(@stack VisTextSetContextFlags flags, word file, word context, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 40 0 14 1 1 1 2 2 0] with: flags with: file with: context with: rangeEnd with: rangeStart!

textSetContext: flags with: context with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_CONTEXT(@stack VisTextSetContextFlags flags, word context, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 41 0 12 1 1 2 2 0] with: flags with: context with: rangeEnd with: rangeStart!

textGetType: flags with: diffs with: type with: rangeEnd with: rangeStart
	"@message TokenAsDWord MSG_VIS_TEXT_GET_TYPE(@stack VisTextGetAttrFlags flags, VisTextTypeDiffs *diffs, VisTextType *type, dword rangeEnd, dword rangeStart)= dx.ax"
	^self geosMessage: #[72 43 160 18 1 3 3 2 2 2] with: flags with: diffs with: type with: rangeEnd with: rangeStart!

textAddType: type
	"@message word MSG_VIS_TEXT_ADD_TYPE(@stack VisTextType type)= ax"
	^self geosMessage: #[72 44 96 10 64 10 1] with: type!

textRemoveType: token
	"@message void MSG_VIS_TEXT_REMOVE_TYPE(word token = cx)"
	^self geosMessage: #[72 45 2 5 1 0] with: token!

textAddName: name with: size with: flags with: data
	"@message TokenAsDWord MSG_VIS_TEXT_ADD_NAME(@stack char *name, word size, NameArrayAddFlags flags, VisTextNameData data)= dx.ax"
	^self geosMessage: #[72 46 160 16 3 1 1 64 8 2] with: name with: size with: flags with: data!

textFindName: name with: size with: data
	"@message word MSG_VIS_TEXT_FIND_NAME(@stack char *name, word size, VisTextnameData *data)= ax"
	^self geosMessage: #[72 47 96 10 3 1 3 1] with: name with: size with: data!

textFindNameByToken: token with: buffer
	"@message void MSG_VIS_TEXT_FIND_NAME_BY_TOKEN(word token = bp, NameArrayMaxElement *buffer = cx:dx)"
	^self geosMessage: #[72 48 3 175 1 3 0] with: token with: buffer!

textAddRefForName: token
	"@message void MSG_VIS_TEXT_ADD_REF_FOR_NAME(word token = cx)"
	^self geosMessage: #[72 49 2 5 1 0] with: token!

textRemoveName: token
	"@message void MSG_VIS_TEXT_REMOVE_NAME(word token = cx)"
	^self geosMessage: #[72 50 2 5 1 0] with: token!

textReplaceWithGraphic: graphic with: sourceFile with: pasteFrame with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_REPLACE_WITH_GRAPHIC(@stack VisTextGraphic graphic, word sourceFile, word pasteFrame, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 51 0 62 64 50 1 1 2 2 0] with: graphic with: sourceFile with: pasteFrame with: rangeEnd with: rangeStart!

textGetGraphicAtPosition: retPtr with: position
	"@message void MSG_VIS_TEXT_GET_GRAPHIC_AT_POSITION(@stack VisTextGraphic *retPtr, dword position)"
	^self geosMessage: #[72 52 0 8 3 2 0] with: retPtr with: position!

textGraphicVariableSize: gstate with: graphic
	"@message SizeAsDWord MSG_VIS_TEXT_GRAPHIC_VARIABLE_SIZE( GStateHandle gstate = cx, VisTextGraphic *graphic = dx:bp)= dx.cx"
	^self geosMessage: #[72 53 167 245 1 3 2] with: gstate with: graphic!

textGraphicVariableDraw: gstate with: graphic
	"@message SizeAsDWord MSG_VIS_TEXT_GRAPHIC_VARIABLE_DRAW( GStateHandle gstate = cx, VisTextGraphic *graphic = dx:bp)= dx.cx"
	^self geosMessage: #[72 54 167 245 1 3 2] with: gstate with: graphic!

textGraphicVariableStartSelect
	"@message void MSG_VIS_TEXT_GRAPHIC_VARIABLE_START_SELECT()"
	^self geosMessage: #[72 55 2 0 0]!

textGraphicVariableOpen
	"@message void MSG_VIS_TEXT_GRAPHIC_VARIABLE_OPEN()"
	^self geosMessage: #[72 56 2 0 0]!

textGraphicVariableClose
	"@message void MSG_VIS_TEXT_GRAPHIC_VARIABLE_CLOSE()"
	^self geosMessage: #[72 57 2 0 0]!

textSaveToDbItem: item with: flags
	"@message DBGroupAndItem MSG_VIS_TEXT_SAVE_TO_DB_ITEM( DBGroupAndItem item = cx.dx, VisTextSaveDBFlags flags = bp)= cx.dx"
	^self geosMessage: #[72 58 155 245 2 1 2] with: item with: flags!

textSaveToDbGroupItem: group with: item with: flags
	"@message DBGroupAndItem MSG_VIS_TEXT_SAVE_TO_DB_GROUP_ITEM(DBGroup group = cx, DBItem item = dx, VisTextSaveDBFlags flags = bp)= cx.dx"
	^self geosMessage: #[72 58 155 245 1 1 1 2] with: group with: item with: flags!

textSaveToDbItemWithStyles: xferFile with: flags with: item with: params
	"@message DBGroupAndItem MSG_VIS_TEXT_SAVE_TO_DB_ITEM_WITH_STYLES(@stack FileHandle xferFile, VisTextSaveDBFlags flags, DBGroupAndItem item, VisTextStyleSheetParams *params)"
	^self geosMessage: #[72 59 0 12 1 1 2 3 2] with: xferFile with: flags with: item with: params!

textLoadFromDbItem: item with: file
	"@message void MSG_VIS_TEXT_LOAD_FROM_DB_ITEM(DBGroupAndItem item = cx.dx, VMFileHandle file = bp)"
	^self geosMessage: #[72 60 3 245 2 1 0] with: item with: file!

textLoadFromDbGroupItem: group with: item with: file
	"@message void MSG_VIS_TEXT_LOAD_FROM_DB_GROUP_ITEM(DBGroup group = cx, DBItem item = dx, VMFileHandle file = bp)"
	^self geosMessage: #[72 60 3 245 1 1 1 0] with: group with: item with: file!

textLoadFromDbItemWithStyles: file with: item with: params
	"@message void MSG_VIS_TEXT_LOAD_FROM_DB_ITEM_WITH_STYLES(@stack FileHandle file, DBGroupAndItem item, StyleSheetParams *params)"
	^self geosMessage: #[72 61 0 10 1 2 3 0] with: file with: item with: params!

textSetVmFile: file
	"@message void MSG_VIS_TEXT_SET_VM_FILE(VMFileHandle file = cx)"
	^self geosMessage: #[72 62 2 5 1 0] with: file!

textCreateStorage: flags with: regionFlag
	"@message void MSG_VIS_TEXT_CREATE_STORAGE(VisTextStorageFlags flags = cl, byte regionFlag = ch)"
	^self geosMessage: #[72 63 2 17 1 1 0] with: flags with: regionFlag!

textChangeElementArray: params with: arrayHandle with: token
	"@message void MSG_VIS_TEXT_CHANGE_ELEMENT_ARRAY( VisTextChangeElementArrayParams params = cx, word arrayHandle = dx, word token = bp)"
	^self geosMessage: #[72 64 3 245 1 1 1 0] with: params with: arrayHandle with: token!

textFreeStorage: removeElementArrays
	"@message void MSG_VIS_TEXT_FREE_STORAGE(Boolean removeElementArrays = cx)"
	^self geosMessage: #[72 65 2 5 4 0] with: removeElementArrays!

textReplaceWithTextTransferFormat: block with: file with: pasteFrame with: end with: start
	"@message void MSG_VIS_TEXT_REPLACE_WITH_TEXT_TRANSFER_FORMAT(@stack VMBlockHandle block, VMFileHandle file, word pasteFrame, dword end, dword start)"
	^self geosMessage: #[72 66 0 14 1 1 1 2 2 0] with: block with: file with: pasteFrame with: end with: start!

textCreateTransferFormat: block with: file with: pasteFrame with: end with: start
	"@message VMBlockHandle MSG_VIS_TEXT_CREATE_TRANSFER_FORMAT(@stack VMBlockHandle block, VMFileHandle file, word pasteFrame, dword end, dword start)= ax"
	^self geosMessage: #[72 67 96 14 1 1 1 2 2 1] with: block with: file with: pasteFrame with: end with: start!

textReplaceAllPtr: text with: textLen
	"@message void MSG_VIS_TEXT_REPLACE_ALL_PTR(const char *text = dx:bp, word textLen = cx)"
	^self geosMessage: #[72 68 3 126 3 1 0] with: text with: textLen!

textReplaceAllOptr: o with: textLen
	"@message void MSG_VIS_TEXT_REPLACE_ALL_OPTR(optr o = dx:bp, word textLen = cx)"
	^self geosMessage: #[72 69 3 126 2 1 0] with: o with: textLen!

textReplaceAllBlock: block with: textLen
	"@message void MSG_VIS_TEXT_REPLACE_ALL_BLOCK(word block = dx, word textLen = cx)"
	^self geosMessage: #[72 70 2 46 1 1 0] with: block with: textLen!

textReplaceAllVmBlock: file with: block with: textLen
	"@message void MSG_VIS_TEXT_REPLACE_ALL_VM_BLOCK(VMFileHandle file = dx, VMBlockHandle block = bp, word textLen = cx)"
	^self geosMessage: #[72 71 3 126 1 1 1 0] with: file with: block with: textLen!

textReplaceAllDbItem: file with: group with: item
	"@message void MSG_VIS_TEXT_REPLACE_ALL_DB_ITEM(VMFileHandle file = dx, DBGroup group = bp, DBItem item = cx)"
	^self geosMessage: #[72 72 3 126 1 1 1 0] with: file with: group with: item!

textReplaceAllHugeArray: file with: hugeArrayBlock with: textLen
	"@message void MSG_VIS_TEXT_REPLACE_ALL_HUGE_ARRAY(VMFileHandle file = dx, VMBlockHandle hugeArrayBlock = bp, word textLen = cx)"
	^self geosMessage: #[72 73 3 126 1 1 1 0] with: file with: hugeArrayBlock with: textLen!

textReplaceSelectionPtr: text with: textLen
	"@message void MSG_VIS_TEXT_REPLACE_SELECTION_PTR(const char *text = dx:bp, word textLen = cx)"
	^self geosMessage: #[72 74 3 126 3 1 0] with: text with: textLen!

textReplaceSelectionOptr: o with: textLen
	"@message void MSG_VIS_TEXT_REPLACE_SELECTION_OPTR(optr o = dx:bp, word textLen = cx)"
	^self geosMessage: #[72 75 3 126 2 1 0] with: o with: textLen!

textReplaceSelectionBlock: block with: textLen
	"@message void MSG_VIS_TEXT_REPLACE_SELECTION_BLOCK(word block = dx, word textLen = cx)"
	^self geosMessage: #[72 76 2 46 1 1 0] with: block with: textLen!

textReplaceSelectionVmBlock: file with: block with: textLen
	"@message void MSG_VIS_TEXT_REPLACE_SELECTION_VM_BLOCK(VMFileHandle file = dx, VMBlockHandle block = bp, word textLen = cx)"
	^self geosMessage: #[72 77 3 126 1 1 1 0] with: file with: block with: textLen!

textReplaceSelectionDbItem: file with: group with: item
	"@message void MSG_VIS_TEXT_REPLACE_SELECTION_DB_ITEM(VMFileHandle file = dx, DBGroup group = bp, DBItem item = cx)"
	^self geosMessage: #[72 78 3 126 1 1 1 0] with: file with: group with: item!

textReplaceSelectionHugeArray: file with: hugeArrayBlock with: textLen
	"@message void MSG_VIS_TEXT_REPLACE_SELECTION_HUGE_ARRAY(VMFileHandle file = dx, VMBlockHandle hugeArrayBlock = bp, word textLen = cx)"
	^self geosMessage: #[72 79 3 126 1 1 1 0] with: file with: hugeArrayBlock with: textLen!

textAppendPtr: text with: textLen
	"@message void MSG_VIS_TEXT_APPEND_PTR(const char *text = dx:bp, word textLen = cx)"
	^self geosMessage: #[72 80 3 126 3 1 0] with: text with: textLen!

textAppendOptr: o with: textLen
	"@message void MSG_VIS_TEXT_APPEND_OPTR(optr o = dx:bp, word textLen = cx)"
	^self geosMessage: #[72 81 3 126 2 1 0] with: o with: textLen!

textAppendBlock: block with: textLen
	"@message void MSG_VIS_TEXT_APPEND_BLOCK(word block = dx, word textLen = cx)"
	^self geosMessage: #[72 82 2 46 1 1 0] with: block with: textLen!

textAppendVmBlock: file with: block with: textLen
	"@message void MSG_VIS_TEXT_APPEND_VM_BLOCK(VMFileHandle file = dx, VMBlockHandle block = bp, word textLen = cx)"
	^self geosMessage: #[72 83 3 126 1 1 1 0] with: file with: block with: textLen!

textAppendDbItem: file with: group with: item
	"@message void MSG_VIS_TEXT_APPEND_DB_ITEM(VMFileHandle file = dx, DBGroup group = bp, DBItem item = cx)"
	^self geosMessage: #[72 84 3 126 1 1 1 0] with: file with: group with: item!

textAppendHugeArray: file with: hugeArrayBlock with: textLen
	"@message void MSG_VIS_TEXT_APPEND_HUGE_ARRAY(VMFileHandle file = dx, VMBlockHandle hugeArrayBlock = bp, word textLen = cx)"
	^self geosMessage: #[72 85 3 126 1 1 1 0] with: file with: hugeArrayBlock with: textLen!

textGetAllPtr: text
	"@message word MSG_VIS_TEXT_GET_ALL_PTR(const char *text = dx:bp)= cx"
	^self geosMessage: #[72 86 102 62 3 1] with: text!

textGetAllOptr: o
	"@message ChunkHandle MSG_VIS_TEXT_GET_ALL_OPTR(optr o = dx:bp)= cx"
	^self geosMessage: #[72 87 102 62 2 1] with: o!

textGetAllBlock: block
	"@message MemHandle MSG_VIS_TEXT_GET_ALL_BLOCK(word block = dx)= cx"
	^self geosMessage: #[72 88 102 6 1 1] with: block!

textGetAllVmBlock: file with: block
	"@message VMBlockHandle MSG_VIS_TEXT_GET_ALL_VM_BLOCK(VMFileHandle file = dx, VMBlockHandle block = bp)= cx"
	^self geosMessage: #[72 89 102 62 1 1 1] with: file with: block!

textGetAllDbItem: file with: group with: item
	"@message DBGroupAndItem MSG_VIS_TEXT_GET_ALL_DB_ITEM(VMFileHandle file = dx, DBGroup group = bp, DBItem item = cx)= bp.cx"
	^self geosMessage: #[72 90 183 126 1 1 1 2] with: file with: group with: item!

textGetAllHugeArray: file with: hugeArrayBlock
	"@message VMBlockHandle MSG_VIS_TEXT_GET_ALL_HUGE_ARRAY(VMFileHandle file = dx, VMBlockHandle hugeArrayBlock = bp)= cx"
	^self geosMessage: #[72 91 102 62 1 1 1] with: file with: hugeArrayBlock!

textGetSelectionPtr: text
	"@message word MSG_VIS_TEXT_GET_SELECTION_PTR(char *text = dx:bp)= cx"
	^self geosMessage: #[72 92 102 62 3 1] with: text!

textGetSelectionOptr: retVal with: block with: chunk
	"@message void MSG_VIS_TEXT_GET_SELECTION_OPTR( VisTextGetReturnStruct *retVal = axcxdxbp, MemHandle block = dx, ChunkHandle chunk = bp)"
	^self geosMessage: #[72 93 198 62 3 1 1 0] with: retVal with: block with: chunk!

textGetSelectionBlock: retVal with: block
	"@message void MSG_VIS_TEXT_GET_SELECTION_BLOCK( VisTextGetReturnStruct *retVal = axcxdxbp, word block = dx)"
	^self geosMessage: #[72 94 198 6 3 1 0] with: retVal with: block!

textGetSelectionVmBlock: retVal with: file with: block
	"@message void MSG_VIS_TEXT_GET_SELECTION_VM_BLOCK( VisTextGetReturnStruct *retVal = axcxdxbp, VMFileHandle file = dx, VMBlockHandle block = bp)"
	^self geosMessage: #[72 95 198 62 3 1 1 0] with: retVal with: file with: block!

textGetSelectionDbItem: retVal with: file with: group with: item
	"@message void MSG_VIS_TEXT_GET_SELECTION_DB_ITEM( VisTextGetReturnStruct *retVal = axcxdxbp, VMFileHandle file = dx, DBGroup group = bp, DBItem item = cx)"
	^self geosMessage: #[72 96 199 126 3 1 1 1 0] with: retVal with: file with: group with: item!

textGetSelectionHugeArray: retval with: file with: hugeArrayBlock
	"@message void MSG_VIS_TEXT_GET_SELECTION_HUGE_ARRAY( VisTextGetHugeArrayReturnStruct *retval = bpaxdxcx, VMFileHandle file = dx, VMBlockHandle hugeArrayBlock = bp)"
	^self geosMessage: #[72 97 210 62 3 1 1 0] with: retval with: file with: hugeArrayBlock!

textDeleteAll
	"@message void MSG_VIS_TEXT_DELETE_ALL()"
	^self geosMessage: #[72 98 2 0 0]!

textDeleteSelection
	"@message void MSG_VIS_TEXT_DELETE_SELECTION()"
	^self geosMessage: #[72 99 2 0 0]!

textGetSelectionRange: vtr
	"@message void MSG_VIS_TEXT_GET_SELECTION_RANGE(VisTextRange *vtr = dx:bp)"
	^self geosMessage: #[72 100 2 62 3 0] with: vtr!

textSelectRangeSmall: start with: end
	"@message void MSG_VIS_TEXT_SELECT_RANGE_SMALL(word start = cx, word end = dx)"
	^self geosMessage: #[72 101 2 53 1 1 0] with: start with: end!

textSelectAll
	"@message void MSG_VIS_TEXT_SELECT_ALL()"
	^self geosMessage: #[72 102 2 0 0]!

textSelectStart
	"@message void MSG_VIS_TEXT_SELECT_START()"
	^self geosMessage: #[72 103 2 0 0]!

textSelectEnd
	"@message void MSG_VIS_TEXT_SELECT_END()"
	^self geosMessage: #[72 104 2 0 0]!

textSelectRelative: newStart with: newEnd
	"@message void MSG_VIS_TEXT_SELECT_RELATIVE(word newStart = cx, word newEnd = dx)"
	^self geosMessage: #[72 105 2 53 1 1 0] with: newStart with: newEnd!

textGetState
	"@message VisTextStates MSG_VIS_TEXT_GET_STATE()=cl"
	^self geosMessage: #[72 106 74 0 1]!

textGetFeatures
	"@message VisTextFeatures MSG_VIS_TEXT_GET_FEATURES()=cx"
	^self geosMessage: #[72 107 102 0 1]!

textSetFeatures: bitsToSet with: bitsToClear
	"@message void MSG_VIS_TEXT_SET_FEATURES(VisTextFeatures bitsToSet=cx, VisTextFeatures bitsToClear=dx)"
	^self geosMessage: #[72 108 2 53 1 1 0] with: bitsToSet with: bitsToClear!

textSetMaxLength: newMaxLength
	"@message void MSG_VIS_TEXT_SET_MAX_LENGTH(word newMaxLength = cx)"
	^self geosMessage: #[72 109 2 5 1 0] with: newMaxLength!

textGetMaxLength
	"@message word MSG_VIS_TEXT_GET_MAX_LENGTH()= cx"
	^self geosMessage: #[72 110 102 0 1]!

textGetUserModifiedState
	"@message Boolean MSG_VIS_TEXT_GET_USER_MODIFIED_STATE()= cx"
	^self geosMessage: #[72 111 102 0 4]!

textSetNotUserModified
	"@message void MSG_VIS_TEXT_SET_NOT_USER_MODIFIED()"
	^self geosMessage: #[72 112 2 0 0]!

textSetUserModified
	"@message void MSG_VIS_TEXT_SET_USER_MODIFIED()"
	^self geosMessage: #[72 113 2 0 0]!

textSetWashColor: modeRed with: blueGreen
	"@message void MSG_VIS_TEXT_SET_WASH_COLOR(VisTextWashColorModeRed modeRed = cx, VisTextWashColorBlueGreen blueGreen = dx)"
	^self geosMessage: #[72 114 2 53 1 1 0] with: modeRed with: blueGreen!

textGetWashColor: retVal
	"@message void MSG_VIS_TEXT_GET_WASH_COLOR(VisTextGetWashColor *retVal = dxcx)"
	^self geosMessage: #[72 115 206 0 3 0] with: retVal!

textModifyEditableSelectable: setBits with: clearBits
	"@message void MSG_VIS_TEXT_MODIFY_EDITABLE_SELECTABLE( VisTextStates setBits = cl, VisTextStates clearBits = ch)"
	^self geosMessage: #[72 116 2 17 1 1 0] with: setBits with: clearBits!

textUpdateGeneric
	"@message void MSG_VIS_TEXT_UPDATE_GENERIC()"
	^self geosMessage: #[72 117 2 0 0]!

textGenerateNotify: params
	"@message void MSG_VIS_TEXT_GENERATE_NOTIFY(VisTextGenerateNotifyParams *params = ss:bp)"
	^self geosMessage: #[72 118 0 128 3 0] with: params!

textCharAttrVirtualToPhysical: attr
	"@message void MSG_VIS_TEXT_CHAR_ATTR_VIRTUAL_TO_PHYSICAL(VisTextCharAttr attr)"
	^self geosMessage: #[72 119 1 0 64 38 0] with: attr!

textParaAttrVirtualToPhysical: attr
	"@message void MSG_VIS_TEXT_PARA_ATTR_VIRTUAL_TO_PHYSICAL(VisTextParaAttr attr)"
	^self geosMessage: #[72 120 1 0 64 72 0] with: attr!

textEditDraw
	"@message void MSG_VIS_TEXT_EDIT_DRAW()"
	^self geosMessage: #[72 121 2 0 0]!

textShowSelection: flags with: yFlags with: yMargin with: xFlags with: xMargin with: bottom with: right with: top with: left
	"@message void MSG_VIS_TEXT_SHOW_SELECTION(@stack VisTextShowSelectionFlags flags, MakeRectVisibleFlags yFlags, MakeRectVisibleMargin yMargin, MakeRectVisibleFlags xFlags, MakeRectVisibleMargin xMargin, sdword bottom, sdword right, sdword top, sdword left)"
	^self geosMessage: #[72 122 0 26 1 1 1 1 1 2 2 2 2 0] with: flags with: yFlags with: yMargin with: xFlags with: xMargin with: bottom with: right with: top with: left!

textHeightNotify: newHeight
	"@message void MSG_VIS_TEXT_HEIGHT_NOTIFY(word newHeight = dx)"
	^self geosMessage: #[72 123 2 6 1 0] with: newHeight!

textEnterOverstrikeMode: calledFromTextObject
	"@message void MSG_VIS_TEXT_ENTER_OVERSTRIKE_MODE(Boolean calledFromTextObject = cx)"
	^self geosMessage: #[72 124 2 5 4 0] with: calledFromTextObject!

textEnterInsertMode: calledFromTextObject
	"@message void MSG_VIS_TEXT_ENTER_INSERT_MODE(Boolean calledFromTextObject = cx)"
	^self geosMessage: #[72 125 2 5 4 0] with: calledFromTextObject!

textGetMinimumDimensions: params
	"@message void MSG_VIS_TEXT_GET_MINIMUM_DIMENSIONS( VisTextMinimumDimensionsParameters *params = dx:bp)"
	^self geosMessage: #[72 126 2 62 3 0] with: params!

textFilterViaReplaceParams: params
	"@message Boolean MSG_VIS_TEXT_FILTER_VIA_REPLACE_PARAMS( VisTextReplaceParameters *params= ss:bp)= carry"
	^self geosMessage: #[72 127 0 128 3 4] with: params!

textFilterViaCharacter: charToFilter
	"@message word MSG_VIS_TEXT_FILTER_VIA_CHARACTER(word charToFilter = cx)= cx"
	^self geosMessage: #[72 128 102 5 1 1] with: charToFilter!

textFilterViaBeforeAfter: before with: after with: frame
	"@message Boolean MSG_VIS_TEXT_FILTER_VIA_BEFORE_AFTER( ChunkHandle before = cx, ChunkHandle after = dx, word frame = bp)= carry"
	^self geosMessage: #[72 129 3 245 1 1 1 4] with: before with: after with: frame!

textLoadStyleSheet: params
	"@message void MSG_VIS_TEXT_LOAD_STYLE_SHEET(StyleSheetParams *params= ss:bp)"
	^self geosMessage: #[72 130 0 128 3 0] with: params!

textLoadStyleSheetParams
	"@message void MSG_VIS_TEXT_LOAD_STYLE_SHEET_PARAMS()"
	^self geosMessage: #[72 131 2 0 0]!

textGetMinWidth
	"@message word MSG_VIS_TEXT_GET_MIN_WIDTH()= cx"
	^self geosMessage: #[72 132 102 0 1]!

textGetAverageCharWidth
	"@message word MSG_VIS_TEXT_GET_AVERAGE_CHAR_WIDTH()= cx"
	^self geosMessage: #[72 133 102 0 1]!

textCalcHeight: width with: cacheResult
	"@message word MSG_VIS_TEXT_CALC_HEIGHT(word width = cx, Boolean cacheResult = dx)= dx"
	^self geosMessage: #[72 134 106 53 1 4 1] with: width with: cacheResult!

textGetLineHeight
	"@message word MSG_VIS_TEXT_GET_LINE_HEIGHT()=ax"
	^self geosMessage: #[72 135 98 0 1]!

textRecalcAndDraw
	"@message void MSG_VIS_TEXT_RECALC_AND_DRAW()"
	^self geosMessage: #[72 136 2 0 0]!

textGetOneLineWidth: charsToCalc
	"@message word MSG_VIS_TEXT_GET_ONE_LINE_WIDTH(word charsToCalc = cx)= cx"
	^self geosMessage: #[72 137 102 5 1 1] with: charsToCalc!

textGetSimpleMinWidth
	"@message word MSG_VIS_TEXT_GET_SIMPLE_MIN_WIDTH()= cx"
	^self geosMessage: #[72 138 102 0 1]!

textScrollOneLine: position
	"@message void MSG_VIS_TEXT_SCROLL_ONE_LINE(word position = cx)"
	^self geosMessage: #[72 139 2 5 1 0] with: position!

textGetScrollAmount: offset with: scrollAmount
	"@message sword MSG_VIS_TEXT_GET_SCROLL_AMOUNT(sword offset = dx, sword scrollAmount = cx)= dx"
	^self geosMessage: #[72 140 106 46 4 4 4] with: offset with: scrollAmount!

textScrollPageUp
	"@message void MSG_VIS_TEXT_SCROLL_PAGE_UP()"
	^self geosMessage: #[72 141 2 0 0]!

textScrollPageDown
	"@message void MSG_VIS_TEXT_SCROLL_PAGE_DOWN()"
	^self geosMessage: #[72 142 2 0 0]!

textScreenUpdate
	"@message void MSG_VIS_TEXT_SCREEN_UPDATE()"
	^self geosMessage: #[72 143 2 0 0]!

textFlashCursorOn
	"@message void MSG_VIS_TEXT_FLASH_CURSOR_ON()"
	^self geosMessage: #[72 144 2 0 0]!

textFlashCursorOff
	"@message void MSG_VIS_TEXT_FLASH_CURSOR_OFF()"
	^self geosMessage: #[72 145 2 0 0]!

textSpellCheckFromOffset: replyObject with: startOffset with: numCharsToCheck with: flags with: icBuff
	"@message void MSG_VIS_TEXT_SPELL_CHECK_FROM_OFFSET(@stack optr replyObject, dword startOffset, dword numCharsToCheck, SpellCheckFromOffsetFlags flags, MemHandle icBuff)"
	^self geosMessage: #[72 146 0 16 2 2 2 1 1 0] with: replyObject with: startOffset with: numCharsToCheck with: flags with: icBuff!

textSearchFromOffset: retStruct with: flags with: currentOffset with: startOffset with: startObject with: searchReplaceStruct
	"@message void MSG_VIS_TEXT_SEARCH_FROM_OFFSET(@stack SearchFromOffsetReturnStruct *retStruct, SearchFromOffsetFlags flags, dword currentOffset, dword startOffset, dword startObject, MemHandle searchReplaceStruct)"
	^self geosMessage: #[72 147 0 20 3 1 2 2 2 1 0] with: retStruct with: flags with: currentOffset with: startOffset with: startObject with: searchReplaceStruct!

textReplaceAllOccurrencesFromOffset: flags with: offset with: infoHan
	"@message word MSG_VIS_TEXT_REPLACE_ALL_OCCURRENCES_FROM_OFFSET(@stack ReplaceAllFromOffsetFlags flags, dword offset, MemHandle infoHan)= cx"
	^self geosMessage: #[72 148 100 8 1 2 1 1] with: flags with: offset with: infoHan!

textReplaceAllOccurrencesInRange: range with: infoHan
	"@message word MSG_VIS_TEXT_REPLACE_ALL_OCCURRENCES_IN_RANGE(@stack VisTextRange range, MemHandle infoHan)= cx"
	^self geosMessage: #[72 149 100 10 64 8 1 1] with: range with: infoHan!

textDoKeyFunction: func with: data
	"@message void MSG_VIS_TEXT_DO_KEY_FUNCTION(VisTextKeyFunction func = cx, word data = bp)"
	^self geosMessage: #[72 151 2 61 1 1 0] with: func with: data!

textReplaceText: params
	"@message Boolean MSG_VIS_TEXT_REPLACE_TEXT(VisTextReplaceParameters *params = ss:bp)= carry"
	^self geosMessage: #[72 152 0 128 3 4] with: params!

textGetTextRange: flags with: reference with: rangeEnd with: rangeStart
	"@message dword MSG_VIS_TEXT_GET_TEXT_RANGE(@stack VisTextGetTextRangeFlags flags, TextReference reference, dword rangeEnd, dword rangeStart)= dx.ax"
	^self geosMessage: #[72 153 160 18 1 64 8 2 2 2] with: flags with: reference with: rangeEnd with: rangeStart!

textSelectRange: end with: start
	"@message void MSG_VIS_TEXT_SELECT_RANGE(@stack dword end, dword start)"
	^self geosMessage: #[72 154 0 8 2 2 0] with: end with: start!

textShowPosition: position
	"@message void MSG_VIS_TEXT_SHOW_POSITION(dword position)"
	^self geosMessage: #[72 155 1 0 2 0] with: position!

textSetFilter: filter
	"@message void MSG_VIS_TEXT_SET_FILTER(VisTextFilters filter = cl)"
	^self geosMessage: #[72 156 2 1 1 0] with: filter!

textGetFilter
	"@message VisTextFilters MSG_VIS_TEXT_GET_FILTER()= cl"
	^self geosMessage: #[72 157 74 0 1]!

textSetOutput: newOutput
	"@message void MSG_VIS_TEXT_SET_OUTPUT(optr newOutput = cx:dx)"
	^self geosMessage: #[72 158 2 53 2 0] with: newOutput!

textGetOutput
	"@message optr MSG_VIS_TEXT_GET_OUTPUT()= cx:dx"
	^self geosMessage: #[72 159 154 0 2]!

textSetLrMargin: lrMargin
	"@message void MSG_VIS_TEXT_SET_LR_MARGIN(byte lrMargin = cl)"
	^self geosMessage: #[72 160 2 1 1 0] with: lrMargin!

textGetLrMargin
	"@message byte MSG_VIS_TEXT_GET_LR_MARGIN()= cl"
	^self geosMessage: #[72 161 74 0 1]!

textSetTbMargin: tbMargin
	"@message void MSG_VIS_TEXT_SET_TB_MARGIN(byte tbMargin = cl)"
	^self geosMessage: #[72 162 2 1 1 0] with: tbMargin!

textGetTbMargin
	"@message byte MSG_VIS_TEXT_GET_TB_MARGIN()= cl"
	^self geosMessage: #[72 163 74 0 1]!

textReplaceWithHwr: context with: ink with: flags with: range
	"@message void MSG_VIS_TEXT_REPLACE_WITH_HWR(@stack HWRContext context, MemHandle ink, VisTextHWRFlags flags, VisTextRange range)"
	^self geosMessage: #[72 164 0 26 64 14 1 1 64 8 0] with: context with: ink with: flags with: range!

textSetHwrContext
	"@message void MSG_VIS_TEXT_SET_HWR_CONTEXT()"
	^self geosMessage: #[72 165 2 0 0]!

textSetHwrFilter
	"@message void MSG_VIS_TEXT_SET_HWR_FILTER()"
	^self geosMessage: #[72 166 2 0 0]!

textSetSelectedTab: position
	"@message void MSG_VIS_TEXT_SET_SELECTED_TAB(word position = cx)"
	^self geosMessage: #[72 167 2 5 1 0] with: position!

textGetTextSize
	"@message dword MSG_VIS_TEXT_GET_TEXT_SIZE()= dx:ax"
	^self geosMessage: #[72 168 162 0 2]!

textInvalidateRange: vtr
	"@message void MSG_VIS_TEXT_INVALIDATE_RANGE(VisTextRange *vtr = dx:bp)"
	^self geosMessage: #[72 169 2 62 3 0] with: vtr!

textAttributeChange
	"@message void MSG_VIS_TEXT_ATTRIBUTE_CHANGE()"
	^self geosMessage: #[72 170 2 0 0]!

textGetLineInfo: retValue with: vtglip
	"@message Boolean MSG_VIS_TEXT_GET_LINE_INFO( VisTextGetLineInfoReturnValues *retValue = dxcx, VisTextGetLineInfoParameters *vtglip = dx:bp)= carry"
	^self geosMessage: #[72 171 206 62 3 3 4] with: retValue with: vtglip!

textDefineName: data
	"@message void MSG_VIS_TEXT_DEFINE_NAME(VisTextNameCommonParams *data=ss:bp)"
	^self geosMessage: #[72 172 0 128 3 0] with: data!

textDeleteName: data
	"@message void MSG_VIS_TEXT_DELETE_NAME(VisTextNameCommonParams *data=ss:bp)"
	^self geosMessage: #[72 173 0 128 3 0] with: data!

textRenameName: data
	"@message void MSG_VIS_TEXT_RENAME_NAME(VisTextNameCommonParams *data=ss:bp)"
	^self geosMessage: #[72 174 0 128 3 0] with: data!

textUpdateNameList: data
	"@message void MSG_VIS_TEXT_UPDATE_NAME_LIST(VisTextNameCommonParams *data = ss:bp)"
	^self geosMessage: #[72 175 0 128 3 0] with: data!

textGetNameListMoniker: data
	"@message void MSG_VIS_TEXT_GET_NAME_LIST_MONIKER(VisTextNameCommonParams *data = ss:bp)"
	^self geosMessage: #[72 176 0 128 3 0] with: data!

textFollowHyperlink: params
	"@message void MSG_VIS_TEXT_FOLLOW_HYPERLINK( VisTextFollowHyperLinkParams *params = ss:bp)"
	^self geosMessage: #[72 177 0 128 3 0] with: params!

textGetLineFromOffset: offset
	"@message dword MSG_VIS_TEXT_GET_LINE_FROM_OFFSET(dword offset=cx.dx)= dx.ax"
	^self geosMessage: #[72 178 162 53 2 2] with: offset!

textGetLineOffsetAndFlags: params
	"@message Boolean MSG_VIS_TEXT_GET_LINE_OFFSET_AND_FLAGS( VisTextGetLineOffsetAndFlagsParameters *params=dx:bp)= carry"
	^self geosMessage: #[72 179 2 62 3 4] with: params!

textGetTextPositionFromCoord: coord
	"@message dword MSG_VIS_TEXT_GET_TEXT_POSITION_FROM_COORD( PointDWFixed *coord = ss:bp)= dx:ax"
	^self geosMessage: #[72 180 160 128 3 2] with: coord!

textGetNameListNameType: data
	"@message void MSG_VIS_TEXT_GET_NAME_LIST_NAME_TYPE(VisTextNameCommonParams *data=ss:bp)"
	^self geosMessage: #[72 181 0 128 3 0] with: data!

textCrossSectionReplaceAborted
	"@message void MSG_VIS_TEXT_CROSS_SECTION_REPLACE_ABORTED()"
	^self geosMessage: #[72 182 2 0 0]!

textSetSpellInProgress
	"@message void MSG_VIS_TEXT_SET_SPELL_IN_PROGRESS()"
	^self geosMessage: #[72 183 2 0 0]!

textSetSearchInProgress
	"@message void MSG_VIS_TEXT_SET_SEARCH_IN_PROGRESS()"
	^self geosMessage: #[72 184 2 0 0]!

textLoadFromDbItemFormat: data
	"@message void MSG_VIS_TEXT_LOAD_FROM_DB_ITEM_FORMAT(void *data = cx:dx)"
	^self geosMessage: #[72 185 2 53 3 0] with: data!

textGetRunBounds: retVal with: runOffset with: position
	"@message void MSG_VIS_TEXT_GET_RUN_BOUNDS(@stack VisTextRange *retVal, word runOffset, dword position)"
	^self geosMessage: #[72 186 0 10 3 1 2 0] with: retVal with: runOffset with: position!

textFreeAllStorage: removeElementArrays
	"@message void MSG_VIS_TEXT_FREE_ALL_STORAGE(Boolean removeElementArrays = cx)"
	^self geosMessage: #[72 187 2 5 4 0] with: removeElementArrays!

textGenerateCursorPositionNotification
	"@message void MSG_VIS_TEXT_GENERATE_CURSOR_POSITION_NOTIFICATION()"
	^self geosMessage: #[72 188 2 0 0]!

textGetSelectionStart
	"@message dword MSG_VIS_TEXT_GET_SELECTION_START()= dx:cx"
	^self geosMessage: #[72 189 166 0 2]!

textGetGstate
	"@message GStateHandle MSG_VIS_TEXT_GET_GSTATE()= cx"
	^self geosMessage: #[72 190 102 0 1]!

textGetFepBounds: retVal with: rect
	"@message Boolean MSG_VIS_TEXT_GET_FEP_BOUNDS( VisTextGetFEPBounds *retVal = dxcx, Rectangle *rect = dx:bp)= carry"
	^self geosMessage: #[72 191 206 62 3 3 4] with: retVal with: rect!

textDeleteAllHyperlinks: flags with: file with: context with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_DELETE_ALL_HYPERLINKS(@stack VisTextSetContextFlags flags, word file, word context, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 192 0 14 1 1 1 2 2 0] with: flags with: file with: context with: rangeEnd with: rangeStart!

textUnsetAllContexts: flags with: context with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_UNSET_ALL_CONTEXTS(@stack VisTextSetContextFlags flags, word context, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 193 0 12 1 1 2 2 0] with: flags with: context with: rangeEnd with: rangeStart!

textConvertOffsetToCoordinate: params
	"@message void MSG_VIS_TEXT_CONVERT_OFFSET_TO_COORDINATE( VisTextConvertOffsetParams *params = dx:bp)"
	^self geosMessage: #[72 194 2 62 3 0] with: params!

textSetHyperlinkTextStyle: extBitsToClear with: extBitsToSet with: styleBitsToClear with: styleBitsToSet with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_HYPERLINK_TEXT_STYLE(@stack VisTextExtendedStyles extBitsToClear, VisTextExtendedStyles extBitsToSet, TextStyle styleBitsToClear, TextStyle styleBitsToSet, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 195 0 16 1 1 1 1 2 2 0] with: extBitsToClear with: extBitsToSet with: styleBitsToClear with: styleBitsToSet with: rangeEnd with: rangeStart!

textUpdateGraphicElement: flags with: graphic with: position
	"@message UpdateGraphicReturnValue MSG_VIS_TEXT_UPDATE_GRAPHIC_ELEMENT( @stack VisTextUpdateGraphicFlags flags, VisTextGraphic graphic, dword position)= ax"
	^self geosMessage: #[72 196 96 56 1 64 50 2 1] with: flags with: graphic with: position!

textNameTokensToListIndices: type
	"@message void MSG_VIS_TEXT_NAME_TOKENS_TO_LIST_INDICES( VisTextNotifyTypeChange *type = ss:bp)"
	^self geosMessage: #[72 197 0 128 3 0] with: type!

textFindNameByIndex: name with: file with: type with: index
	"@message word MSG_VIS_TEXT_FIND_NAME_BY_INDEX(@stack char *name, word file, VisTextNameType type, word index)= ax"
	^self geosMessage: #[72 198 96 10 3 1 1 1 1] with: name with: file with: type with: index!

textRegionFromPoint
	"@message void MSG_VIS_TEXT_REGION_FROM_POINT()"
	^self geosMessage: #[72 199 2 0 0]!

textGetNameListMonikerFrame: data
	"@message void MSG_VIS_TEXT_GET_NAME_LIST_MONIKER_FRAME( VisTextNameCommonParams *data=ss:bp)"
	^self geosMessage: #[72 200 0 128 3 0] with: data!

textGetSingleCharAttr
	"@message void MSG_VIS_TEXT_GET_SINGLE_CHAR_ATTR()"
	^self geosMessage: #[72 201 2 0 0]!

textSetContextGivenNameText: object with: flags with: context with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_SET_CONTEXT_GIVEN_NAME_TEXT(@stack optr object, VisTextSetContextFlags flags, word context, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 202 0 16 2 1 1 2 2 0] with: object with: flags with: context with: rangeEnd with: rangeStart!

textRedirectHyperlinks: flags with: context with: rangeEnd with: rangeStart
	"@message void MSG_VIS_TEXT_REDIRECT_HYPERLINKS(@stack VisTextSetContextFlags flags, word context, dword rangeEnd, dword rangeStart)"
	^self geosMessage: #[72 203 0 12 1 1 2 2 0] with: flags with: context with: rangeEnd with: rangeStart!

!

!TextRuler comment!
Library text, file objects/text/tctrlc.goh! !

!TextRuler class methodsFor: 'library linkage'!

library
	^78!

entry
	^29!
!

!TextRuler methodsFor: 'Geos instance variables'!

triTabControl
	"@instance optr TRI_tabControl"
	^self dwordAt: 82!

triTabControl: value
	"@instance optr TRI_tabControl"
	^self dwordAt: 82 put: value!

triValid
	"@instance byte TRI_valid"
	^self byteAt: 86!

triValid: value
	"@instance byte TRI_valid"
	^self byteAt: 86 put: value!

triFlags
	"@instance TextRulerFlags TRI_flags"
	^self byteAt: 87!

triFlags: value
	"@instance TextRulerFlags TRI_flags"
	^self byteAt: 87 put: value!

triAction
	"@instance TextRulerAction TRI_action"
	^self byteAt: 88!

triAction: value
	"@instance TextRulerAction TRI_action"
	^self byteAt: 88 put: value!

triRegionWidth
	"@instance word TRI_regionWidth"
	^self wordAt: 89!

triRegionWidth: value
	"@instance word TRI_regionWidth"
	^self wordAt: 89 put: value!

triGcnContent
	"@instance optr TRI_gcnContent"
	^self dwordAt: 91!

triGcnContent: value
	"@instance optr TRI_gcnContent"
	^self dwordAt: 91 put: value!

triSelectedTab
	"@instance word TRI_selectedTab"
	^self wordAt: 95!

triSelectedTab: value
	"@instance word TRI_selectedTab"
	^self wordAt: 95 put: value!

triSelectedObject
	"@instance word TRI_selectedObject"
	^self wordAt: 97!

triSelectedObject: value
	"@instance word TRI_selectedObject"
	^self wordAt: 97 put: value!

triSelectX
	"@instance sword TRI_selectX"
	^self wordAt: 99!

triSelectX: value
	"@instance sword TRI_selectX"
	^self wordAt: 99 put: value!

triDiffs
	"@instance VisTextParaAttrDiffs TRI_diffs"
	^GCSVisTextParaAttrDiffs forPointer: (self ptrAt: 101).!

triDiffs: aBlock
	"@instance VisTextParaAttrDiffs TRI_diffs"
	aBlock value: (GCSVisTextParaAttrDiffs forPointer: (self ptrAt: 101)).!

triParaAttr
	"@instance VisTextMaxParaAttr TRI_paraAttr"
	^GCSVisTextMaxParaAttr forPointer: (self ptrAt: 114).!

triParaAttr: aBlock
	"@instance VisTextMaxParaAttr TRI_paraAttr"
	aBlock value: (GCSVisTextMaxParaAttr forPointer: (self ptrAt: 114)).!

!

!TextRuler methodsFor: 'Geos vardata'!

!

!TextRuler methodsFor: 'Geos messages'!

rulerSetGcnContent: content
	"@message void MSG_TEXT_RULER_SET_GCN_CONTENT(optr content = cx:dx)"
	^self geosMessage: #[74 0 2 53 2 0] with: content!

rulerSetControlledAttrs: attrs
	"@message void MSG_TEXT_RULER_SET_CONTROLLED_ATTRS( TextRulerControlAttributes attrs = cx)"
	^self geosMessage: #[74 1 2 5 1 0] with: attrs!

!

!VisLargeText comment!
Library text, file objects/vltextc.goh! !

!VisLargeText class methodsFor: 'library linkage'!

library
	^78!

entry
	^35!
!

!VisLargeText methodsFor: 'Geos instance variables'!

vltiRegionArray
	"@instance ChunkHandle VLTI_regionArray"
	^self wordAt: 98!

vltiRegionArray: value
	"@instance ChunkHandle VLTI_regionArray"
	^self wordAt: 98 put: value!

vltiDisplayMode
	"@instance VisLargeTextDisplayModes VLTI_displayMode"
	^self wordAt: 100!

vltiDisplayMode: value
	"@instance VisLargeTextDisplayModes VLTI_displayMode"
	^self wordAt: 100 put: value!

vltiRegionSpacing
	"@instance word VLTI_regionSpacing"
	^self wordAt: 102!

vltiRegionSpacing: value
	"@instance word VLTI_regionSpacing"
	^self wordAt: 102 put: value!

vltiDraftRegionSize
	"@instance XYSize VLTI_draftRegionSize"
	^GCSXYSize forPointer: (self ptrAt: 104).!

vltiDraftRegionSize: aBlock
	"@instance XYSize VLTI_draftRegionSize"
	aBlock value: (GCSXYSize forPointer: (self ptrAt: 104)).!

vltiTotalHeight
	"@instance dword VLTI_totalHeight"
	^self dwordAt: 108!

vltiTotalHeight: value
	"@instance dword VLTI_totalHeight"
	^self dwordAt: 108 put: value!

vltiDisplayModeWidth
	"@instance word VLTI_displayModeWidth"
	^self wordAt: 112!

vltiDisplayModeWidth: value
	"@instance word VLTI_displayModeWidth"
	^self wordAt: 112 put: value!

vltiFlags
	"@instance VisLargeTextFlags VLTI_flags"
	^self wordAt: 114!

vltiFlags: value
	"@instance VisLargeTextFlags VLTI_flags"
	^self wordAt: 114 put: value!

vltiAttrs
	"@instance VisLargeTextAttrs VLTI_attrs"
	^self wordAt: 116!

vltiAttrs: value
	"@instance VisLargeTextAttrs VLTI_attrs"
	^self wordAt: 116 put: value!

!

!VisLargeText methodsFor: 'Geos vardata'!

!

!VisLargeText methodsFor: 'Geos messages'!

largeTextCreateDataStructures
	"@message void MSG_VIS_LARGE_TEXT_CREATE_DATA_STRUCTURES()"
	^self geosMessage: #[74 0 2 0 0]!

largeTextAppendRegion: region
	"@message void MSG_VIS_LARGE_TEXT_APPEND_REGION(word region = cx)"
	^self geosMessage: #[74 1 2 5 1 0] with: region!

largeTextRegionIsLast: region
	"@message void MSG_VIS_LARGE_TEXT_REGION_IS_LAST(word region = cx)"
	^self geosMessage: #[74 2 2 5 1 0] with: region!

largeTextCurrentRegionChanged: region
	"@message void MSG_VIS_LARGE_TEXT_CURRENT_REGION_CHANGED(word region = cx)"
	^self geosMessage: #[74 3 2 5 1 0] with: region!

largeTextRegionChanged: region
	"@message void MSG_VIS_LARGE_TEXT_REGION_CHANGED(word region = cx)"
	^self geosMessage: #[74 4 2 5 1 0] with: region!

largeTextSetDisplayMode: mode
	"@message void MSG_VIS_LARGE_TEXT_SET_DISPLAY_MODE( VisLargeTextDisplayModes mode = cx)"
	^self geosMessage: #[74 5 2 5 1 0] with: mode!

largeTextSetDraftRegionSize: width with: height
	"@message void MSG_VIS_LARGE_TEXT_SET_DRAFT_REGION_SIZE(word width = cx, word height = dx)"
	^self geosMessage: #[74 6 2 53 1 1 0] with: width with: height!

largeTextGetDraftRegionSize: region
	"@message XYValueAsDWord MSG_VIS_LARGE_TEXT_GET_DRAFT_REGION_SIZE( word region = cx)= dx.cx"
	^self geosMessage: #[74 7 166 5 1 2] with: region!

largeTextGetRegionCount
	"@message word MSG_VIS_LARGE_TEXT_GET_REGION_COUNT()= cx"
	^self geosMessage: #[74 8 102 0 1]!

largeTextGetRegionPos: retVal with: region
	"@message void MSG_VIS_LARGE_TEXT_GET_REGION_POS( VisLargeTextGetRegionPosReturnStruct *retVal = bpaxdxcx, word region = cx)"
	^self geosMessage: #[74 9 210 5 3 1 0] with: retVal with: region!

largeTextRegionFromPoint
	"@message void MSG_VIS_LARGE_TEXT_REGION_FROM_POINT()"
	^self geosMessage: #[74 10 2 0 0]!

!

!BorderControl comment!
Library text, file objects/text/tctrlc.goh! !

!BorderControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^23!
!

!BorderControl methodsFor: 'Geos instance variables'!

!

!BorderControl methodsFor: 'Geos vardata'!

!

!BorderControl methodsFor: 'Geos messages'!

setSimpleBorder
	"@message void MSG_BC_SET_SIMPLE_BORDER()"
	^self geosMessage: #[108 0 2 0 0]!

setBorderBits
	"@message void MSG_BC_SET_BORDER_BITS()"
	^self geosMessage: #[108 1 2 0 0]!

setBorderWidth
	"@message void MSG_BC_SET_BORDER_WIDTH()"
	^self geosMessage: #[108 2 2 0 0]!

setBorderSpacing
	"@message void MSG_BC_SET_BORDER_SPACING()"
	^self geosMessage: #[108 3 2 0 0]!

setBorderType
	"@message void MSG_BC_SET_BORDER_TYPE()"
	^self geosMessage: #[108 4 2 0 0]!

borderTypeStatus
	"@message void MSG_BC_BORDER_TYPE_STATUS()"
	^self geosMessage: #[108 5 2 0 0]!

setBorderAnchor
	"@message void MSG_BC_SET_BORDER_ANCHOR()"
	^self geosMessage: #[108 6 2 0 0]!

setShadowWidth
	"@message void MSG_BC_SET_SHADOW_WIDTH()"
	^self geosMessage: #[108 7 2 0 0]!

borderSidesStatus
	"@message void MSG_BC_BORDER_SIDES_STATUS()"
	^self geosMessage: #[108 8 2 0 0]!

!

!DefaultTabsControl comment!
Library text, file objects/text/tctrlc.goh! !

!DefaultTabsControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^20!
!

!DefaultTabsControl methodsFor: 'Geos instance variables'!

!

!DefaultTabsControl methodsFor: 'Geos vardata'!

!

!DefaultTabsControl methodsFor: 'Geos messages'!

setDefaultTabs: spacing
	"@message void MSG_DTC_SET_DEFAULT_TABS(WWFixed spacing = dx:cx)"
	^self geosMessage: #[108 0 2 46 2 0] with: spacing!

setDefaultTabsViaList: tabs
	"@message void MSG_DTC_SET_DEFAULT_TABS_VIA_LIST(word tabs = cx)"
	^self geosMessage: #[108 1 2 5 1 0] with: tabs!

!

!DropCapControl comment!
Library text, file objects/text/tctrlc.goh! !

!DropCapControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^25!
!

!DropCapControl methodsFor: 'Geos instance variables'!

!

!DropCapControl methodsFor: 'Geos vardata'!

!

!DropCapControl methodsFor: 'Geos messages'!

setDropCap: spacing
	"@message void MSG_DCC_SET_DROP_CAP(word spacing = cx)"
	^self geosMessage: #[108 0 2 5 1 0] with: spacing!

userChangedDropCap
	"@message void MSG_DCC_USER_CHANGED_DROP_CAP()"
	^self geosMessage: #[108 1 2 0 0]!

setDropChars: value
	"@message void MSG_DCC_SET_DROP_CHARS(word value = dx)"
	^self geosMessage: #[108 2 2 6 1 0] with: value!

setDropLines: value
	"@message void MSG_DCC_SET_DROP_LINES(word value = dx)"
	^self geosMessage: #[108 3 2 6 1 0] with: value!

setDropPosition: value
	"@message void MSG_DCC_SET_DROP_POSITION(word value = dx)"
	^self geosMessage: #[108 4 2 6 1 0] with: value!

!

!FontAttrControl comment!
Library text, file objects/text/tctrlc.goh! !

!FontAttrControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^17!
!

!FontAttrControl methodsFor: 'Geos instance variables'!

!

!FontAttrControl methodsFor: 'Geos vardata'!

!

!FontAttrControl methodsFor: 'Geos messages'!

setFontWeight: weight
	"@message void MSG_FAC_SET_FONT_WEIGHT(word weight = dx)"
	^self geosMessage: #[108 0 2 6 1 0] with: weight!

setFontWidth: width
	"@message void MSG_FAC_SET_FONT_WIDTH(word width = dx)"
	^self geosMessage: #[108 1 2 6 1 0] with: width!

setTrackKerning: kern
	"@message void MSG_FAC_SET_TRACK_KERNING(word kern = dx)"
	^self geosMessage: #[108 2 2 6 1 0] with: kern!

!

!FontControl comment!
Library text, file objects/text/tctrlc.goh! !

!FontControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^13!
!

!FontControl methodsFor: 'Geos instance variables'!

!

!FontControl methodsFor: 'Geos vardata'!

attrFontControlShortListFontType: value
	"@vardata FontEnumFlags ATTR_FONT_CONTROL_SHORT_LIST_FONT_TYPE"
	^self addVardata: ##attrFontControlShortListFontType byte: value!

attrFontControlLongListFontType: value
	"@vardata FontEnumFlags ATTR_FONT_CONTROL_LONG_LIST_FONT_TYPE"
	^self addVardata: ##attrFontControlLongListFontType byte: value!

!

!FontControl methodsFor: 'Geos messages'!

setFont: fontID
	"@message void MSG_FC_SET_FONT(word fontID = cx)"
	^self geosMessage: #[108 0 2 5 1 0] with: fontID!

setFontFromList: fontID
	"@message void MSG_FC_SET_FONT_FROM_LIST(word fontID = cx)"
	^self geosMessage: #[108 1 2 5 1 0] with: fontID!

userChangedFontFromList: fontID
	"@message void MSG_FC_USER_CHANGED_FONT_FROM_LIST(word fontID = cx)"
	^self geosMessage: #[108 2 2 5 1 0] with: fontID!

!

!HyphenationControl comment!
Library text, file objects/text/tctrlc.goh! !

!HyphenationControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^26!
!

!HyphenationControl methodsFor: 'Geos instance variables'!

!

!HyphenationControl methodsFor: 'Geos vardata'!

!

!HyphenationControl methodsFor: 'Geos messages'!

setHyphenation: spacing
	"@message void MSG_HC_SET_HYPHENATION(word spacing = cx)"
	^self geosMessage: #[108 0 2 5 1 0] with: spacing!

userChangedHyphenation
	"@message void MSG_HC_USER_CHANGED_HYPHENATION()"
	^self geosMessage: #[108 1 2 0 0]!

setMaxRange: max
	"@message void MSG_HC_SET_MAX_RANGE(word max = dx)"
	^self geosMessage: #[108 2 2 6 1 0] with: max!

setMinWord: min
	"@message void MSG_HC_SET_MIN_WORD(word min = dx)"
	^self geosMessage: #[108 3 2 6 1 0] with: min!

setMinPrefix: min
	"@message void MSG_HC_SET_MIN_PREFIX(word min = dx)"
	^self geosMessage: #[108 4 2 6 1 0] with: min!

setMinSuffix: min
	"@message void MSG_HC_SET_MIN_SUFFIX(word min = dx)"
	^self geosMessage: #[108 5 2 6 1 0] with: min!

!

!JustificationControl comment!
Library text, file objects/text/tctrlc.goh! !

!JustificationControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^18!
!

!JustificationControl methodsFor: 'Geos instance variables'!

!

!JustificationControl methodsFor: 'Geos vardata'!

!

!JustificationControl methodsFor: 'Geos messages'!

setJustification
	"@message void MSG_JC_SET_JUSTIFICATION()"
	^self geosMessage: #[108 0 2 0 0]!

!

!LineSpacingControl comment!
Library text, file objects/text/tctrlc.goh! !

!LineSpacingControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^42!
!

!LineSpacingControl methodsFor: 'Geos instance variables'!

!

!LineSpacingControl methodsFor: 'Geos vardata'!

!

!LineSpacingControl methodsFor: 'Geos messages'!

setLineSpacing: spacing
	"@message void MSG_LASC_SET_LINE_SPACING(BBFixed spacing = cx)"
	^self geosMessage: #[108 0 2 5 1 0] with: spacing!

setLineSpacingWwFixed: spacing
	"@message void MSG_LASC_SET_LINE_SPACING_WW_FIXED(WWFixed spacing = dx:cx)"
	^self geosMessage: #[108 1 2 46 2 0] with: spacing!

setLeadingType: leadingType
	"@message void MSG_LASC_SET_LEADING_TYPE(word leadingType = cx)"
	^self geosMessage: #[108 2 2 5 1 0] with: leadingType!

userChangedLeadingType
	"@message void MSG_LASC_USER_CHANGED_LEADING_TYPE()"
	^self geosMessage: #[108 3 2 0 0]!

setManualLeading: leadingType
	"@message void MSG_LASC_SET_MANUAL_LEADING(word leadingType = cx)"
	^self geosMessage: #[108 4 2 5 1 0] with: leadingType!

!

!MarginControl comment!
Library text, file objects/text/tctrlc.goh! !

!MarginControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^30!
!

!MarginControl methodsFor: 'Geos instance variables'!

!

!MarginControl methodsFor: 'Geos vardata'!

!

!MarginControl methodsFor: 'Geos messages'!

setLeftMargin: margin
	"@message void MSG_MC_SET_LEFT_MARGIN(WWFixed margin = dx:cx)"
	^self geosMessage: #[108 0 2 46 2 0] with: margin!

setParaMargin: margin
	"@message void MSG_MC_SET_PARA_MARGIN(WWFixed margin = dx:cx)"
	^self geosMessage: #[108 1 2 46 2 0] with: margin!

setRightMargin: margin
	"@message void MSG_MC_SET_RIGHT_MARGIN(WWFixed margin = dx:cx)"
	^self geosMessage: #[108 2 2 46 2 0] with: margin!

!

!ParaAttrControl comment!
Library text, file objects/text/tctrlc.goh! !

!ParaAttrControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^22!
!

!ParaAttrControl methodsFor: 'Geos instance variables'!

!

!ParaAttrControl methodsFor: 'Geos vardata'!

!

!ParaAttrControl methodsFor: 'Geos messages'!

setParaAttr
	"@message void MSG_PAC_SET_PARA_ATTR()"
	^self geosMessage: #[108 0 2 0 0]!

setKeep: selectedBooleans with: changedBooleans
	"@message void MSG_PAC_SET_KEEP(word selectedBooleans = cx, word changedBooleans = bp)"
	^self geosMessage: #[108 1 2 61 1 1 0] with: selectedBooleans with: changedBooleans!

userChangedKeep
	"@message void MSG_PAC_USER_CHANGED_KEEP()"
	^self geosMessage: #[108 2 2 0 0]!

setKeepFirst: value
	"@message void MSG_PAC_SET_KEEP_FIRST(word value = dx)"
	^self geosMessage: #[108 3 2 6 1 0] with: value!

setKeepLast: value
	"@message void MSG_PAC_SET_KEEP_LAST(word value = dx)"
	^self geosMessage: #[108 4 2 6 1 0] with: value!

!

!ParaSpacingControl comment!
Library text, file objects/text/tctrlc.goh! !

!ParaSpacingControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^19!
!

!ParaSpacingControl methodsFor: 'Geos instance variables'!

!

!ParaSpacingControl methodsFor: 'Geos vardata'!

!

!ParaSpacingControl methodsFor: 'Geos messages'!

setSpaceOnTop: spacing
	"@message void MSG_PASC_SET_SPACE_ON_TOP(word spacing = dx)"
	^self geosMessage: #[108 0 2 6 1 0] with: spacing!

setSpaceOnBottom: spacing
	"@message void MSG_PASC_SET_SPACE_ON_BOTTOM(word spacing = dx)"
	^self geosMessage: #[108 1 2 6 1 0] with: spacing!

!

!PointSizeControl comment!
Library text, file objects/text/tctrlc.goh! !

!PointSizeControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^14!
!

!PointSizeControl methodsFor: 'Geos instance variables'!

!

!PointSizeControl methodsFor: 'Geos vardata'!

!

!PointSizeControl methodsFor: 'Geos messages'!

setPointSize: size
	"@message void MSG_PSC_SET_POINT_SIZE(WWFixed size = dx:cx)"
	^self geosMessage: #[108 0 2 46 2 0] with: size!

setPointSizeFromList: size
	"@message void MSG_PSC_SET_POINT_SIZE_FROM_LIST(word size = cx)"
	^self geosMessage: #[108 1 2 5 1 0] with: size!

smallerPointSize
	"@message void MSG_PSC_SMALLER_POINT_SIZE()"
	^self geosMessage: #[108 2 2 0 0]!

largerPointSize
	"@message void MSG_PSC_LARGER_POINT_SIZE()"
	^self geosMessage: #[108 3 2 0 0]!

!

!SearchReplaceControl comment!
Library text, file objects/text/tctrlc.goh! !

!SearchReplaceControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^28!
!

!SearchReplaceControl methodsFor: 'Geos instance variables'!

srciFocusInfo
	"@instance SearchReplaceFocusInfo SRCI_focusInfo"
	^self byteAt: 25!

srciFocusInfo: value
	"@instance SearchReplaceFocusInfo SRCI_focusInfo"
	^self byteAt: 25 put: value!

srciEnableFlags
	"@instance SearchReplaceEnableFlags SRCI_enableFlags"
	^self byteAt: 26!

srciEnableFlags: value
	"@instance SearchReplaceEnableFlags SRCI_enableFlags"
	^self byteAt: 26 put: value!

srciHaveSelection
	"@instance byte SRCI_haveSelection"
	^self byteAt: 27!

srciHaveSelection: value
	"@instance byte SRCI_haveSelection"
	^self byteAt: 27 put: value!

!

!SearchReplaceControl methodsFor: 'Geos vardata'!

attrSearchControlSetFindNextMoniker: value
	"@vardata ChunkHandle ATTR_SEARCH_CONTROL_SET_FIND_NEXT_MONIKER"
	^self addVardata: ##attrSearchControlSetFindNextMoniker word: value!

attrSearchControlSetFindPrevMoniker: value
	"@vardata ChunkHandle ATTR_SEARCH_CONTROL_SET_FIND_PREV_MONIKER"
	^self addVardata: ##attrSearchControlSetFindPrevMoniker word: value!

attrSearchControlSetReplaceCurrentMoniker: value
	"@vardata ChunkHandle ATTR_SEARCH_CONTROL_SET_REPLACE_CURRENT_MONIKER"
	^self addVardata: ##attrSearchControlSetReplaceCurrentMoniker word: value!

attrSearchControlSetReplaceAllMoniker: value
	"@vardata ChunkHandle ATTR_SEARCH_CONTROL_SET_REPLACE_ALL_MONIKER"
	^self addVardata: ##attrSearchControlSetReplaceAllMoniker word: value!

attrSearchControlSetReplaceAllInSelectionMoniker: value
	"@vardata ChunkHandle ATTR_SEARCH_CONTROL_SET_REPLACE_ALL_IN_SELECTION_MONIKER"
	^self addVardata: ##attrSearchControlSetReplaceAllInSelectionMoniker word: value!

attrSearchControlInteractOnlyWithTargetedTextObjects
	"@vardata void ATTR_SEARCH_CONTROL_INTERACT_ONLY_WITH_TARGETED_TEXT_OBJECTS"
	^self addVardata: ##attrSearchControlInteractOnlyWithTargetedTextObjects!

attrSearchControlSelectionType: value
	"@vardata SelectionDataType ATTR_SEARCH_CONTROL_SELECTION_TYPE"
	^self addVardata: ##attrSearchControlSelectionType word: value!

attrSearchControlSetFindFromTopMoniker: value
	"@vardata ChunkHandle ATTR_SEARCH_CONTROL_SET_FIND_FROM_TOP_MONIKER"
	^self addVardata: ##attrSearchControlSetFindFromTopMoniker word: value!

attrSearchControlSetIncludeNoteMoniker: value
	"@vardata ChunkHandle ATTR_SEARCH_CONTROL_SET_INCLUDE_NOTE_MONIKER"
	^self addVardata: ##attrSearchControlSetIncludeNoteMoniker word: value!

attrSearchControlSetExcludeNoteMoniker: value
	"@vardata ChunkHandle ATTR_SEARCH_CONTROL_SET_EXCLUDE_NOTE_MONIKER"
	^self addVardata: ##attrSearchControlSetExcludeNoteMoniker word: value!

attrSearchControlSetNoteOnlyMoniker: value
	"@vardata ChunkHandle ATTR_SEARCH_CONTROL_SET_NOTE_ONLY_MONIKER"
	^self addVardata: ##attrSearchControlSetNoteOnlyMoniker word: value!

!

!SearchReplaceControl methodsFor: 'Geos messages'!

sendEventToSearchText: event
	"@message void MSG_SRC_SEND_EVENT_TO_SEARCH_TEXT(EventHandle event=bp)"
	^self geosMessage: #[108 0 2 7 1 0] with: event!

sendEventToReplaceText: event
	"@message void MSG_SRC_SEND_EVENT_TO_REPLACE_TEXT(EventHandle event=bp)"
	^self geosMessage: #[108 1 2 7 1 0] with: event!

replaceAllOccurrencesQueryResponse
	"@message void MSG_SRC_REPLACE_ALL_OCCURRENCES_QUERY_RESPONSE()"
	^self geosMessage: #[108 2 2 0 0]!

replaceAllOccurrencesNoQuery
	"@message void MSG_SRC_REPLACE_ALL_OCCURRENCES_NO_QUERY()"
	^self geosMessage: #[108 3 2 0 0]!

findNext
	"@message void MSG_SRC_FIND_NEXT()"
	^self geosMessage: #[108 4 2 0 0]!

findPrev
	"@message void MSG_SRC_FIND_PREV()"
	^self geosMessage: #[108 5 2 0 0]!

addSpecialCharToFocusText: specialChar
	"@message void MSG_SRC_ADD_SPECIAL_CHAR_TO_FOCUS_TEXT(SpecialChar specialChar = cl)"
	^self geosMessage: #[108 6 2 1 1 0] with: specialChar!

updateSpecialCharsByFocusInfo
	"@message void MSG_SRC_UPDATE_SPECIAL_CHARS_BY_FOCUS_INFO()"
	^self geosMessage: #[108 7 2 0 0]!

searchAborted
	"@message void MSG_SRC_SEARCH_ABORTED()"
	^self geosMessage: #[108 8 2 0 0]!

searchStringNotFoundForSearch
	"@message void MSG_SRC_SEARCH_STRING_NOT_FOUND_FOR_SEARCH()"
	^self geosMessage: #[108 9 2 0 0]!

searchStringNotFoundForReplaceAll
	"@message void MSG_SRC_SEARCH_STRING_NOT_FOUND_FOR_REPLACE_ALL()"
	^self geosMessage: #[108 10 2 0 0]!

searchStringNotFoundForReplaceAllInSelection
	"@message void MSG_SRC_SEARCH_STRING_NOT_FOUND_FOR_REPLACE_ALL_IN_SELECTION()"
	^self geosMessage: #[108 11 2 0 0]!

findFromTop
	"@message void MSG_SRC_FIND_FROM_TOP()"
	^self geosMessage: #[108 12 2 0 0]!

getNoteSearchState
	"@message SearchNoteOptionType MSG_SRC_GET_NOTE_SEARCH_STATE()= cl"
	^self geosMessage: #[108 13 74 0 1]!

!

!TabControl comment!
Library text, file objects/text/tctrlc.goh! !

!TabControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^31!
!

!TabControl methodsFor: 'Geos instance variables'!

tciNumberOfTabs
	"@instance word TCI_numberOfTabs"
	^self wordAt: 25!

tciNumberOfTabs: value
	"@instance word TCI_numberOfTabs"
	^self wordAt: 25 put: value!

tciTabList
	"@instance Tab[25] TCI_tabList"
	"#pointer [27, 200]"
	^self!

tciSelectedTab
	"@instance word TCI_selectedTab"
	^self wordAt: 227!

tciSelectedTab: value
	"@instance word TCI_selectedTab"
	^self wordAt: 227 put: value!

!

!TabControl methodsFor: 'Geos vardata'!

!

!TabControl methodsFor: 'Geos messages'!

selectTab
	"@message void MSG_TC_SELECT_TAB()"
	^self geosMessage: #[108 0 2 0 0]!

queryTab
	"@message void MSG_TC_QUERY_TAB()"
	^self geosMessage: #[108 1 2 0 0]!

setTabLine
	"@message void MSG_TC_SET_TAB_LINE()"
	^self geosMessage: #[108 2 2 0 0]!

clearTab
	"@message void MSG_TC_CLEAR_TAB()"
	^self geosMessage: #[108 3 2 0 0]!

clearAllTabs
	"@message void MSG_TC_CLEAR_ALL_TABS()"
	^self geosMessage: #[108 4 2 0 0]!

setTabType
	"@message void MSG_TC_SET_TAB_TYPE()"
	^self geosMessage: #[108 5 2 0 0]!

!

!TextCountControl comment!
Library text, file objects/text/tctrlc.goh! !

!TextCountControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^37!
!

!TextCountControl methodsFor: 'Geos instance variables'!

!

!TextCountControl methodsFor: 'Geos vardata'!

!

!TextCountControl methodsFor: 'Geos messages'!

recalc
	"@message void MSG_TCC_RECALC()"
	^self geosMessage: #[108 0 2 0 0]!

!

!TextHelpControl comment!
Library text, file objects/text/tctrlc.goh! !

!TextHelpControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^36!
!

!TextHelpControl methodsFor: 'Geos instance variables'!

thciFile
	"@instance word THCI_file"
	^self wordAt: 25!

thciFile: value
	"@instance word THCI_file"
	^self wordAt: 25 put: value!

!

!TextHelpControl methodsFor: 'Geos vardata'!

tempCurrentContextIndex: value
	"@vardata word TEMP_CURRENT_CONTEXT_INDEX"
	^self addVardata: ##tempCurrentContextIndex word: value!

!

!TextHelpControl methodsFor: 'Geos messages'!

addContext
	"@message void MSG_THC_ADD_CONTEXT()"
	^self geosMessage: #[108 0 2 0 0]!

deleteContext
	"@message void MSG_THC_DELETE_CONTEXT()"
	^self geosMessage: #[108 1 2 0 0]!

renameContext
	"@message void MSG_THC_RENAME_CONTEXT()"
	^self geosMessage: #[108 2 2 0 0]!

setContext: curSelection
	"@message void MSG_THC_SET_CONTEXT(word curSelection = cx)"
	^self geosMessage: #[108 3 2 5 1 0] with: curSelection!

dcGetMoniker: list
	"@message void MSG_THC_DC_GET_MONIKER(optr list = cx:dx)"
	^self geosMessage: #[108 4 2 53 2 0] with: list!

scGetMoniker: list
	"@message void MSG_THC_SC_GET_MONIKER(optr list = cx:dx)"
	^self geosMessage: #[108 5 2 53 2 0] with: list!

addFile
	"@message void MSG_THC_ADD_FILE()"
	^self geosMessage: #[108 6 2 0 0]!

deleteFile
	"@message void MSG_THC_DELETE_FILE()"
	^self geosMessage: #[108 7 2 0 0]!

renameFile
	"@message void MSG_THC_RENAME_FILE()"
	^self geosMessage: #[108 8 2 0 0]!

dfGetMoniker: list
	"@message void MSG_THC_DF_GET_MONIKER(optr list = cx:dx)"
	^self geosMessage: #[108 9 2 53 2 0] with: list!

dfFileChanged: curSelection
	"@message void MSG_THC_DF_FILE_CHANGED(word curSelection = cx)"
	^self geosMessage: #[108 10 2 5 1 0] with: curSelection!

shFileChanged: curSelection
	"@message void MSG_THC_SH_FILE_CHANGED(word curSelection = cx)"
	^self geosMessage: #[108 11 2 5 1 0] with: curSelection!

setHyperlink: curSelection
	"@message void MSG_THC_SET_HYPERLINK(word curSelection = cx)"
	^self geosMessage: #[108 12 2 5 1 0] with: curSelection!

followHyperlink
	"@message void MSG_THC_FOLLOW_HYPERLINK()"
	^self geosMessage: #[108 13 2 0 0]!

shGetMoniker: list
	"@message void MSG_THC_SH_GET_MONIKER(optr list = cx:dx)"
	^self geosMessage: #[108 14 2 53 2 0] with: list!

dcContextChanged: curSelection
	"@message void MSG_THC_DC_CONTEXT_CHANGED(word curSelection = cx)"
	^self geosMessage: #[108 15 2 5 1 0] with: curSelection!

deleteAllHyperlinks
	"@message void MSG_THC_DELETE_ALL_HYPERLINKS()"
	^self geosMessage: #[108 16 2 0 0]!

unsetAllContexts
	"@message void MSG_THC_UNSET_ALL_CONTEXTS()"
	^self geosMessage: #[108 17 2 0 0]!

!

!TextRulerControl comment!
Library text, file objects/text/tctrlc.goh! !

!TextRulerControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^34!
!

!TextRulerControl methodsFor: 'Geos instance variables'!

trciAttrs
	"@instance TextRulerControlAttributes TRCI_attrs"
	^self wordAt: 25!

trciAttrs: value
	"@instance TextRulerControlAttributes TRCI_attrs"
	^self wordAt: 25 put: value!

!

!TextRulerControl methodsFor: 'Geos vardata'!

!

!TextRulerControl methodsFor: 'Geos messages'!

changeState: selectedBooleans with: changedBooleans
	"@message void MSG_TRCC_CHANGE_STATE(word selectedBooleans = cx, word changedBooleans = bp)"
	^self geosMessage: #[108 0 2 61 1 1 0] with: selectedBooleans with: changedBooleans!

!

!TextStyleControl comment!
Library text, file objects/text/tctrlc.goh! !

!TextStyleControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^8!
!

!TextStyleControl methodsFor: 'Geos instance variables'!

!

!TextStyleControl methodsFor: 'Geos vardata'!

!

!TextStyleControl methodsFor: 'Geos messages'!

plainTextChange
	"@message void MSG_TSC_PLAIN_TEXT_CHANGE()"
	^self geosMessage: #[108 0 2 0 0]!

styleChange: selectedBooleans with: changedBooleans
	"@message void MSG_TSC_STYLE_CHANGE(word selectedBooleans = cx, word changedBooleans = bp)"
	^self geosMessage: #[108 1 2 61 1 1 0] with: selectedBooleans with: changedBooleans!

extendedStyleChange: selectedBooleans with: changedBooleans
	"@message void MSG_TSC_EXTENDED_STYLE_CHANGE(word selectedBooleans = cx, word changedBooleans = bp)"
	^self geosMessage: #[108 2 2 61 1 1 0] with: selectedBooleans with: changedBooleans!

!

!BorderColorControl comment!
Library text, file objects/text/tctrlc.goh! !

!BorderColorControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^24!
!

!BorderColorControl methodsFor: 'Geos instance variables'!

!

!BorderColorControl methodsFor: 'Geos vardata'!

!

!BorderColorControl methodsFor: 'Geos messages'!

!

!CharBGColorControl comment!
Library text, file objects/text/tctrlc.goh! !

!CharBGColorControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^16!
!

!CharBGColorControl methodsFor: 'Geos instance variables'!

!

!CharBGColorControl methodsFor: 'Geos vardata'!

!

!CharBGColorControl methodsFor: 'Geos messages'!

!

!CharFGColorControl comment!
Library text, file objects/text/tctrlc.goh! !

!CharFGColorControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^15!
!

!CharFGColorControl methodsFor: 'Geos instance variables'!

!

!CharFGColorControl methodsFor: 'Geos vardata'!

!

!CharFGColorControl methodsFor: 'Geos messages'!

!

!ParaBGColorControl comment!
Library text, file objects/text/tctrlc.goh! !

!ParaBGColorControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^21!
!

!ParaBGColorControl methodsFor: 'Geos instance variables'!

!

!ParaBGColorControl methodsFor: 'Geos vardata'!

!

!ParaBGColorControl methodsFor: 'Geos messages'!

!

!TextStyleSheetControl comment!
Library text, file objects/text/tctrlc.goh! !

!TextStyleSheetControl class methodsFor: 'library linkage'!

library
	^78!

entry
	^27!
!

!TextStyleSheetControl methodsFor: 'Geos instance variables'!

!

!TextStyleSheetControl methodsFor: 'Geos vardata'!

!

!TextStyleSheetControl methodsFor: 'Geos messages'!

!

